package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: DomainEnableStatus.java , v 0.1 2018/5/15 下午4:01 ZhouFeng Exp $
 */
public enum DomainEnableStatus {

    DELETE("删除", 0),

    AVALIABLE("可用", 1),

    USING("使用中", 2),

    DISABLE("停用", 3),;


    private String desc;

    private Integer code;

    DomainEnableStatus(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }


    public static DomainEnableStatus of(Integer code) {
        return CACHE.get(code);
    }


    public boolean same(Integer code) {
        return this.code.equals(code);
    }


    private static final Map<Integer, DomainEnableStatus> CACHE = Maps.uniqueIndex(Arrays.asList(DomainEnableStatus
            .values()), DomainEnableStatus::getCode);

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
