package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * Created by zhou_wb on 2018/6/26.
 */
public enum UserLandOptEnum {
    //被咬
    BITTEN("BITTEN","{{%s}}蒙面去{{%s}}家偷红包，不料被狗咬伤，现在已被送去医院"),

    //获取红包达到10个
    GET_10_RED_PACKETS("GET_10_RED_PACKETS","{{%s}}今天已经收了{{%s}}个红包了，大家投来羡慕的目光"),

    //解锁六块土地
    UNLOCK_OVER_6_LANDS("UNLOCK_OVER_6_LANDS","功夫不负有心人，{{%s}}通过自己的努力在家里开垦出了{{%s}}块土地啦"),

    //好友列表达到10个以上
    ADD_OVER_10_FRIENDS("ADD_OVER_10_FRIENDS","{{%s}}在加了{{%s}}为好友后，成功变身农场交际花"),

    //解锁日签菜单
    UNLOCK_SIGN_EASTER_EGG("UNLOCK_SIGN_EASTER_EGG","{{%s}}在收取完红包后，意外收获“早起的鸟儿”勋章"),

    //获得看门狗
    GAIN_DOG("GAIN_DOG","恭喜{{%s}}获得稀有道具-看门狗一只"),

    //成功偷取红包
    STEALING_RED_PACKETS("STEALING_RED_PACKETS","{{%s}}成功偷到了{{%s}}个红包"),

    //翻倍达到一定数值
    DOUBLE_TIMES_LIMIT("DOUBLE_TIMES_LIMIT","{{%s}}使用金币卡翻倍，喜获{{%s}}金币奖励")
    ;

    private static final Map<String,UserLandOptEnum> OPT_EUM = Maps.uniqueIndex(Arrays.asList(UserLandOptEnum.values()),UserLandOptEnum::getType);

    public static UserLandOptEnum getByKey(String key) {
        UserLandOptEnum userLandOptEnum = OPT_EUM.get(key);
        if (userLandOptEnum != null) {
            return userLandOptEnum;
        }
        return null;
    }
    UserLandOptEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
