package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.plan.NormalRewardDto;
import cn.com.duiba.tuia.news.center.dto.plan.PlanCondition;
import cn.com.duiba.tuia.news.center.dto.req.OutOrderDto;

/**
 * Created by xiaotian on 2018/7/9
 * @author xiaotian
 */
@AdvancedFeignClient
public interface RemotePlanService {

    /**
     * 初始化任务
     * @param userId
     * @return
     */
    boolean init(Long userId);

    /**
     * 获取任务列表详情
     * @param userId
     * @return
     */
    PlanCondition   getPlanCondition(Long userId,String system);

    /**
     * 获取普通任务奖励
     * @return
     */
   NormalRewardDto getNormalReward(Long userId) throws BizException;

    /**
     * 根据任务Id获取任务奖励数量
     * @param userId
     * @param taskId
     * @return
     */
    NormalRewardDto getRewardByTaskId(Long userId,Long taskId) throws BizException;

}
