package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.util.JiGuangPushUtils;

import java.util.Map;

/**
 * Created by zhou_wb on 2018/4/28.
 */
public enum AndroidPushNotificationEnum {

    TODAY_READ("TODAY_READ",JiGuangPushUtils.TODAY_READ_TITLE,JiGuangPushUtils.TODAY_READ_ALERT,JiGuangPushUtils.URL_WALLET_ACTIVITY, JiGuangPushUtils.WALLETPAGEMAP()),

    TODAY_SIGN("TODAY_SIGN",JiGuangPushUtils.TODAY_SIGN_TITLE,JiGuangPushUtils.TODAY_SING_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.MAINPAGEMAP()),

    DIS_RED_PACKET("DIS_RED_PACKET",JiGuangPushUtils.DIS_RED_PACK_TITLE,JiGuangPushUtils.DIS_RED_PACK_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.MAINPAGEMAP()),

    RECALL("RECALL",JiGuangPushUtils.RECALL_TITLE,JiGuangPushUtils.RECALL_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.MAINPAGEMAP()),

    LAND_PACKET("LAND_PACKET",JiGuangPushUtils.LAND_PACKET_TITLE,JiGuangPushUtils.LAND_PACKET_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.LANDMAP()),

    LIMIT_PACKET_HELP("LIMIT_PACKET_HELP",JiGuangPushUtils.LIMIT_PACKET_HELP_TITLE,JiGuangPushUtils.LIMIT_PACKET_HELP_ALERT,JiGuangPushUtils.URL_LIMIT_PACKET_ACTIVITY,JiGuangPushUtils.LIMITPACKETMAP()),

    INVITE_SUCCESS("INVITE_SUCCESS",JiGuangPushUtils.INVITE_SUCCESS_TITLE,JiGuangPushUtils.INVITE_SUCCESS_ALERT,JiGuangPushUtils.URL_INVITE_ACTIVITY,JiGuangPushUtils.INVITEMAP()),

    PACKET_DOUBLE("PACKET_DOUBLE",JiGuangPushUtils.DOUBLE_PACKET_TITLE,JiGuangPushUtils.DOUBLE_PACKET_ALERT,JiGuangPushUtils.URL_INVITE_ACTIVITY,JiGuangPushUtils.INVITEMAP()),

    LUCK_PACKET_IN("LUCK_PACKET_IN",JiGuangPushUtils.LUCK_PACKET_SEND_IN_TITLE,JiGuangPushUtils.LUCK_PACKET_SEND_IN_ALERT,JiGuangPushUtils.URL_LUCK_PACKET_ACTIVITY,JiGuangPushUtils.LUCKPACKETMAP()),

    LUCK_PACKET_WAIT("LUCK_PACKET_WAIT",JiGuangPushUtils.LUCK_PACKET_SEND_WAIT_TITLE,JiGuangPushUtils.LUCK_PACKET_SEND_WAIT_ALERT,JiGuangPushUtils.URL_LUCK_PACKET_ACTIVITY,JiGuangPushUtils.LUCKPACKETMAP()),

    /**
     * 1.红包熟了推送：新用户农场未领取也算有； 文案1
     */
    WAKE_TO_PICK_1("WAKE_TO_PICK_1",JiGuangPushUtils.WAKE_TO_PICK_1_TITLE,JiGuangPushUtils.WAKE_TO_PICK_1_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.REDPACKETFARMMAP()),

    /**
     *  1.红包熟了推送：新用户农场未领取也算有； 文案2
     */
    WAKE_TO_PICK_2("WAKE_TO_PICK_2",JiGuangPushUtils.WAKE_TO_PICK_2_TITLE,JiGuangPushUtils.WAKE_TO_PICK_2_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.REDPACKETFARMMAP()),

    /**
     * 点点赚推送
     */
    POINT_PACKET("POINT_PACKET",JiGuangPushUtils.POINT_PACKET_TITLE,JiGuangPushUtils.POINT_PACKET_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.POINTPACKETINTRMAP()),

    /**
     * 活动金币收益
     */
    ACTIVITY_SET_COIN_REWARD("ACTIVITY_SET_COIN_REWARD",JiGuangPushUtils.ACTIVITY_REWARD_TITLE,JiGuangPushUtils.ACTIVITY_REWARD_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.ACTIVITYCOINREWARD()),

    /**
     * 活动合集
     */
    ACTIVITY_SET("ACTIVITY_SET",JiGuangPushUtils.ACTIVITY_SET_TITLE,JiGuangPushUtils.ACTIVITY_SET_ALERT,JiGuangPushUtils.URL_MAIN_ACTIVITY,JiGuangPushUtils.ACTIVITYCOINREWARD()),
    ;

    private String type;

    private String title;

    private String alert;

    private String activityUrl;

    private Map<String,String>  extra;

    AndroidPushNotificationEnum(String type, String title, String alert, String activityUrl, Map<String, String> extra) {
        this.type = type;
        this.title = title;
        this.alert = alert;
        this.activityUrl = activityUrl;
        this.extra = extra;
    }

    public String getActivityUrl() {
        return activityUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAlert() {
        return alert;
    }

    public void setAlert(String alert) {
        this.alert = alert;
    }

    public Map<String, String> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, String> extra) {
        this.extra = extra;
    }

    public static AndroidPushNotificationEnum getByType(String type){
        for (AndroidPushNotificationEnum androidPushNotificationEnum :values()
             ) {
            if (androidPushNotificationEnum.type.equals(type)){
                return androidPushNotificationEnum;
            }
        }
        return null;
    }
}
