package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.util.JiGuangPushUtils;
import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: PushMessageEnum.java , v 0.1 2018/5/24 下午5:26 ZhouFeng Exp $
 */
public enum PushMessageEnum {

    /**
     * 好玩tab红点通知
     */
    HAOWAN_POINT(1, "redPoint",null),

    /**
     * 邀请零钱奖励通知
     */
    INVITE_CHANGE_REWARD(2, "inviteChangeReward",null),

    /**
     * 拼手气红包收益到账
     */
    LUCK_PACKET_INCOME(3,"luckPacketIncome", JiGuangPushUtils.LUCKPACKETMAP()),

    /**
     * 点点赚应用内推送
     */
    POINT_PACKET_ADD(4,"pointPacketAdd",JiGuangPushUtils.POINTPACKETMAP()),

    /**
     * 活动金币收益
     */
    ACTIVITY_SET_COIN_REWARD(5,"activitySetCoinReward",JiGuangPushUtils.ACTIVITYCOINREWARD()),
    ;


    private Integer code;

    private String content;

    private Map<String,String> extra;

    PushMessageEnum(Integer code, String content, Map<String, String> extra) {
        this.code = code;
        this.content = content;
        this.extra = extra;
    }

    private static final Map<Integer, PushMessageEnum> CACHE = Maps.uniqueIndex(Arrays.asList(values()),
            PushMessageEnum::getCode);

    public static PushMessageEnum of(Integer code) {
        return CACHE.get(code);
    }


    public Integer getCode() {
        return code;
    }

    public String getContent() {
        return content;
    }

    public Map<String, String> getExtra() {
        return extra;
    }
}
