package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.CashPacketDto;
import cn.com.duiba.tuia.news.center.dto.UserCashPacketDto;
import cn.com.duiba.tuia.news.center.dto.withdrawTicket.MyPageWithdrawConditionDto;
import cn.com.duiba.tuia.news.center.dto.withdrawTicket.NewCashPacketDto;

import java.util.List;

/**
 * @author xiaotian
 * @Date: 2018/8/17 17:40
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteNewCashPacketService {

    /**
     * 获取用户现金红包
     * @param userId 用户id
     * @return
     */
    NewCashPacketDto getUserCashPacket(Long userId);

    /**
     * 获取我的页面新增的窗口（一元提现或者任务进度）
     * @param userId
     * @return
     */
    MyPageWithdrawConditionDto getMypageCondition(Long userId);

    /**
     * 获取用户所有现金红包
     * @param userId
     * @return
     */
    List<UserCashPacketDto> getUserCashPackets(Long userId);


}
