package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.Response.WechatServiceDto;
import cn.com.duiba.tuia.news.center.dto.Response.WechatUrlConfig;
import cn.com.duiba.tuia.news.center.dto.Response.WechatUrlDto;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;

import java.util.List;

/**
 * Created by xiaotian on 2018/7/12.
 */
@AdvancedFeignClient
public interface RemoteWechatUrlService {

    /**
     * 根据版本号获取当前在用的微信服务号
     * @param version 版本号 0：老  1：新
     * @return
     */
    WechatServiceDto getPresentService(Integer version);

    /**
     * 获取当前在用的微信服务号集合
     * @return
     */
    List<WechatServiceDto> getPresentServiceList();


    /**
     * 根据服务号Id获取服务号信息
     * @param serviceId
     * @return
     */
    WechatServiceDto getServiceById(Long serviceId);

    /**
     * 分页获取微信服务号
     * @param version 版本号 0:老 1：新
     * @param pageNo 页号
     * @param pageSize 页量
     * @return
     */
    PageQueryResultDto<WechatServiceDto> getServicePageList(Integer version,Integer pageNo, Integer pageSize);


    /**
     * 根据服务号Id和url类型获取列表
     * @param serviceId 服务号Id
     * @param type 1：后端 2：Jssdk
     * @return
     */
    PageQueryResultDto<WechatUrlDto> getUrlPageList(Long serviceId, Integer type, Integer pageNo, Integer pageSize);

    /**
     * 添加服务号
     * @param version 版本号 0:老 1：新
     * @param serviceId
     * @param name
     * @param appid
     * @param appsecret
     * @return
     */
    boolean addService(Integer version,Long serviceId,String name,String appid,String appsecret);

    /**
     * 重置服务号
     * @param serviceId
     * @return
     */
    boolean resetService(Long serviceId);

    /**
     * 删除url
     * @param urlId url的id
     * @return
     */
    boolean delUrl(Long urlId);

    /**
     * 添加url
     * @param url
     * @param type  1：后端 2：Jssdk
     * @param serviceId 服务号Id
     * @return
     */
    boolean addUrl(String url,Long serviceId,Integer type) throws BizException;

    /**
     * 切换域名
     * @param version  版本号 0:老 1：新
     * @param serviceId
     * @param type
     * @return
     */
    boolean changeUrl(Integer version,Long serviceId,Integer type) throws BizException;

    /**
     * 获取当前服务号配置
     * @return
     */
    List<WechatUrlConfig> getConfig();

}
