package cn.com.duiba.tuia.news.center.enums;

/**
 * @author ElinZhou
 * @version $Id: WithdrawChannelType.java , v 0.1 2018/1/2 下午5:56 ElinZhou Exp $
 */
public enum WithdrawChannelType {

    /**
     * 支付宝人工
     */
    ALIPAY_MANUAL(1, "支付宝人工"),
    ALIPAY_SYSTEM(2," 支付宝系统")


    ;

    private Integer code;
    private String desc;

    WithdrawChannelType(Integer code,String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public static WithdrawChannelType of(Integer aCode) {
        if (aCode == null) {
            return null;
        }
        for (WithdrawChannelType withdrawChannelType : values()) {
            if (withdrawChannelType.getCode().equals(aCode)) {
                return withdrawChannelType;
            }
        }
        return null;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);

    }
}
