package cn.com.duiba.tuia.news.center.dto;

import cn.com.duiba.tuia.news.center.enums.ValidStatusEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: AppConfigDto.java , v 0.1 2018/7/19 下午2:29 ElinZhou Exp $
 */
public class AppConfigDto implements Serializable{


    private static final long serialVersionUID = 2883621778291169506L;
    private Long id;

    /**
     * 键
     */
    private String keyName;

    /**
     * 值
     */
    private String valueContent;

    /**
     * 生效状态
     */
    private ValidStatusEnum validStatus;

    /**
     * 开始版本号（包括）
     */
    private Long versionStart;

    /**
     * 结束版本号（不包括）
     */
    private Long versionEnd;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    private Integer platform;

    public AppConfigDto(String keyName, String valueContent, Integer platform) {
        this.keyName = keyName;
        this.valueContent = valueContent;
        this.platform = platform;
    }

    public AppConfigDto() {
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Integer getPlatform() {
        return platform;
    }

    public void setPlatform(Integer platform) {
        this.platform = platform;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getKeyName() {
        return keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getValueContent() {
        return valueContent;
    }

    public void setValueContent(String valueContent) {
        this.valueContent = valueContent;
    }

    public ValidStatusEnum getValidStatus() {
        return validStatus;
    }

    public void setValidStatus(ValidStatusEnum validStatus) {
        this.validStatus = validStatus;
    }

    public Long getVersionStart() {
        return versionStart;
    }

    public void setVersionStart(Long versionStart) {
        this.versionStart = versionStart;
    }

    public Long getVersionEnd() {
        return versionEnd;
    }

    public void setVersionEnd(Long versionEnd) {
        this.versionEnd = versionEnd;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
