package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.enums.OpenInstallSourceType;

/**
 * Created by xuefeng on 2018/11/21.
 */
@AdvancedFeignClient
public interface RemoteRiskService {

    /**
     * 端外阅读奖励风控检验
     *
     * @param userInfo 用户唯一标识
     * @param type 内容类型
     * @param contentId 内容id
     * @return true:风控通过，给予奖励 false:风控拒绝，不给予奖励
     */
    Boolean readCheck(String userInfo, OpenInstallSourceType type, String contentId);

    /**
     * 记录金币奖励行为
     *
     * @param userInfo 用户唯一标识
     * @param type 内容类型
     * @param contentId 内容id
     */
    void recordShare(String userInfo, OpenInstallSourceType type, Long contentId);

    /**
     * 分享链接添加加密分享时间
     *
     * @param url 分享链接
     * @return
     */
    String buildShareUrlWithTime(String url);
}
