/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums.message;

import cn.com.duiba.tuia.news.center.enums.AndroidPushCustomEnum;
import com.google.common.base.Joiner;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MessageCode {
    CASH_SUCESS("\u63d0\u73b0\u6210\u529f", "\u63d0\u73b0\u6210\u529f", "\u60a8\u7684{1}\u5143\u63d0\u73b0\u7533\u8bf7\u5df2\u5ba1\u6838\u901a\u8fc7\uff0c\u8bf7\u53ca\u65f6\u5728{2}\u4e2d\u67e5\u770b\u8d44\u91d1\u53d8\u52a8\u3002", true, "", AndroidPushCustomEnum.CASH_SUCESS);

    private String name;
    private String title;
    private String message;
    private boolean needPush;
    private String jumpUrl;
    private AndroidPushCustomEnum pushType;
    private static Map<String, MessageCode> cache;

    private MessageCode(String name, String title, String message, boolean needPush, String jumpUrl, AndroidPushCustomEnum pushType) {
        this.name = name;
        this.title = title;
        this.message = message;
        this.needPush = needPush;
        this.jumpUrl = jumpUrl;
        this.pushType = pushType;
    }

    public static String getDbMessage(String ... value) {
        if (value == null) {
            return null;
        }
        return Joiner.on((String)"^").join((Object[])value);
    }

    public static MessageCode getByCode(String code) {
        return cache.get(code.toUpperCase());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isNeedPush() {
        return this.needPush;
    }

    public void setNeedPush(boolean needPush) {
        this.needPush = needPush;
    }

    public String getJumpUrl() {
        return this.jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public AndroidPushCustomEnum getPushType() {
        return this.pushType;
    }

    public void setPushType(AndroidPushCustomEnum pushType) {
        this.pushType = pushType;
    }

    static {
        cache = Stream.of(MessageCode.values()).collect(Collectors.toMap(a -> a.name().toUpperCase(), a -> a));
    }
}

