package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @Auther: wsz
 * @Date: 2018/8/16 17:25
 * @Description:
 */
public enum LanuchAdTypeEnum {
    OWN_AD(0,"自持广告"),
    BAIDU_MSSP_AD(1,"百度MSSP"),
    TUIA_AD(2,"推啊展示广告"),
    ;

    private Integer type;
    private String desc;

    private static final Map<Integer, LanuchAdTypeEnum> CACHE = Maps.uniqueIndex(Arrays.asList(LanuchAdTypeEnum
            .values()), LanuchAdTypeEnum::getType);

    LanuchAdTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static LanuchAdTypeEnum get(Integer type){return CACHE.get(type);}
}
