package cn.com.duiba.tuia.news.center.enums;

import org.apache.commons.lang.math.RandomUtils;

/**
 * 1.6.2 之后的w用户注册的用户使用的第二轮以上的签到逻辑
 *
 * @author lichao 2018/11/14
 */
public enum OldUserSignInRewardV6 implements SignInReward {

    DAY_ONE(1, 20, 20, 20, RewardUnit.COIN),

    DAY_TWO(2, 50, 50, 50, RewardUnit.COIN),

    DAY_THREE(3, 5, 8, 200, RewardUnit.CHANGE),

    DAY_FOUR(4, 50, 50, 50, RewardUnit.COIN),

    DAY_FIVE(5, 100, 100, 100, RewardUnit.COIN),

    DAY_SIX(6, 50, 50, 50, RewardUnit.COIN),

    DAY_SEVEN(7, 5, 8, 12, RewardUnit.CHANGE);

    private Integer day;
    private Integer rewardFeeMin;//随机的最小,不可小于1
    private Integer rewardFeeMax;//随机的最大

    private Integer topReward;//最高多少

    private RewardUnit rewardUnit;//单位


    OldUserSignInRewardV6(Integer day, Integer rewardFeeMin, Integer rewardFeeMax, Integer topReward, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFeeMin = rewardFeeMin;
        this.rewardFeeMax = rewardFeeMax;
        this.rewardUnit = rewardUnit;
        this.topReward = topReward;
    }

    @Override
    public Long getRewardFee() {
        int i = RandomUtils.nextInt(getRewardFeeMax() + 1 - getRewardFeeMin()) + getRewardFeeMin();
        return Long.valueOf(i);
    }


    @Override
    public Long getTopRewardNew() {
        //1.6.2 之后的用户没有最高的提示
        Integer topReward = getTopReward();
        if(topReward==null){
            return null;
        }
        return Long.valueOf(topReward);
    }

    @Override
    public Integer getDay() {
        return day;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return rewardUnit;
    }

    public void setDay(Integer day) {
        this.day = day;
    }

    public Integer getRewardFeeMin() {
        return rewardFeeMin;
    }

    public void setRewardFeeMin(Integer rewardFeeMin) {
        this.rewardFeeMin = rewardFeeMin;
    }

    public Integer getRewardFeeMax() {
        return rewardFeeMax;
    }

    public void setRewardFeeMax(Integer rewardFeeMax) {
        this.rewardFeeMax = rewardFeeMax;
    }

    public void setRewardUnit(RewardUnit rewardUnit) {
        this.rewardUnit = rewardUnit;
    }

    public Integer getTopReward() {
        return topReward;
    }

    public void setTopReward(Integer topReward) {
        this.topReward = topReward;
    }
}
