package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.tuia.news.center.dto.PartnerDetailDto;
import cn.com.duiba.tuia.news.center.dto.TeamMemberIncome;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;
import cn.com.duiba.tuia.news.center.dto.req.PartnerApplyReq;

/**
 * 合伙人相关接口
 *
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemotePartnerService.java , v 0.1 2018-11-25 14:02 ElinZhou Exp $
 */
public interface RemotePartnerService {

    /**
     * 申请成为合伙人
     *
     * @param req
     * @return
     */
    boolean apply(PartnerApplyReq req) throws BizException;


    /**
     * 合伙人详情
     *
     * @param userId
     * @return
     */
    PartnerDetailDto detail(Long userId);


    /**
     * 团队成员详情
     *
     * @param userId
     * @param page     当前页
     * @param pageSize 每页数量
     * @return
     */
    PageQueryResultDto<TeamMemberIncome> teamDetail(Long userId, Integer page, Integer pageSize);

}
