package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @Auther: wsz
 * @Date: 2018/8/6 11:30
 * @Description:
 */
public enum NewUserRewardTypeEnum {
    SIGN(1,"签到"),READING(2,"阅读"),FARM(3,"农场");
    private int type;
    private String desc;

    private static final Map<Integer, NewUserRewardTypeEnum> CACHE = Maps.uniqueIndex(Arrays.asList(NewUserRewardTypeEnum.values()),NewUserRewardTypeEnum::getType);

    NewUserRewardTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static NewUserRewardTypeEnum getByType(Integer type) {
        return CACHE.get(type);
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
