package cn.com.duiba.tuia.news.center.enums.message;

import cn.com.duiba.tuia.news.center.enums.AndroidPushCustomEnum;
import com.google.common.base.Joiner;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 个人消息中心的消息类型
 * 此消息类型为个人消息中心的文案,由于文案几乎一致,减少数据库磁盘压力,数据库只存储code,查询时进行文案拼接
 * @author lichao 2018/11/27
 */
public enum MessageCode {

    REWARD_SUCESS("收益到账","收益到账通知","您昨日收入的{1}金币已经自动兑换为{2}元，今天也要继续努力赚钱呀。",true,AndroidPushCustomEnum.SHOUYI),//"2000^1"

    CASH_SUCESS("提现成功","提现成功","您的{1}元提现申请已审核通过，请及时在{2}中查看资金变动。",true,AndroidPushCustomEnum.CASH_SUCESS);//10^支付宝

    private String name;//通知场景

    private String title;//通知标题

    private String message;//通知文案

    private boolean needPush;//是否需要推送

    private AndroidPushCustomEnum pushType;//推送跳转页面类型

    MessageCode(String name, String title, String message, boolean needPush, AndroidPushCustomEnum pushType) {
        this.name = name;
        this.title = title;
        this.message = message;
        this.needPush = needPush;
        this.pushType = pushType;
    }

    /** 获取内容的存入数据库的message */
    public static String getDbMessage(String... value){
        if(value==null){
            return null;
        }
        return Joiner.on("^").join(value);
    }

    private static Map<String, MessageCode>  cache = Stream.of(MessageCode.values()).collect(Collectors.toMap(a -> a.name().toUpperCase(), a -> a));


    public static MessageCode getByCode(String code){
        return cache.get(code.toUpperCase());
    }



    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isNeedPush() {
        return needPush;
    }

    public void setNeedPush(boolean needPush) {
        this.needPush = needPush;
    }


    public AndroidPushCustomEnum getPushType() {
        return pushType;
    }

    public void setPushType(AndroidPushCustomEnum pushType) {
        this.pushType = pushType;
    }
}
