package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.ApplyWithdrawDto;
import cn.com.duiba.tuia.news.center.dto.BaseQueryDto;
import cn.com.duiba.tuia.news.center.dto.UserWithdrawDetailDto;
import cn.com.duiba.tuia.news.center.dto.WithdrawApplyDto;
import cn.com.duiba.tuia.news.center.dto.WithdrawOrderDto;
import cn.com.duiba.tuia.news.center.dto.firstscreen.FirstScreenAdDto;
import cn.com.duiba.tuia.news.center.dto.firstscreen.LaunchDto;
import cn.com.duiba.tuia.news.center.dto.firstscreen.OwnAdvertDto;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;
import cn.com.duiba.tuia.news.center.dto.req.UserActionStatisticDto;
import cn.com.duiba.tuia.news.center.dto.req.WithdrawQueryDto;
import cn.com.duiba.tuia.news.center.dto.req.firstscreen.FirstScreenAdReqDto;
import cn.com.duiba.tuia.news.center.dto.req.firstscreen.LaunchSortReqDto;
import cn.com.duiba.tuia.news.center.dto.req.firstscreen.OwnAdvertDeleteReqDto;
import cn.com.duiba.tuia.news.center.dto.req.firstscreen.OwnAdvertReqDto;
import cn.com.duiba.tuia.news.center.dto.req.firstscreen.OwnAdvertSortReqDto;
import cn.com.duiba.tuia.news.center.enums.ApplyStatus;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author zhou_wb
 */
@AdvancedFeignClient
public interface RemoteFirstScreenService {

    /**
     * 获取首屏广告配置
     * @param firstScreenAdReqDto
     * @return
     */
    FirstScreenAdDto getFirstScreenConfig(FirstScreenAdReqDto firstScreenAdReqDto);


    /**
     * 获取首屏广告配置V2
     * @param firstScreenAdReqDto
     * @version 1.6.6
     */
    FirstScreenAdDto getFirstScreenConfigV2(FirstScreenAdReqDto firstScreenAdReqDto);


    /**
     * 更新投放策略配置开启状态以及排序
     */
    void updateLaunchConfig(List<LaunchSortReqDto> launchSortReqDtos);

    /**
     * 更新自持广告列表开启状态以及排序
     */
    void updateOwnAdSortAndEnable(List<OwnAdvertSortReqDto> ownAdvertSortReqDtos);


    /**
     * 更新自持广告内容信息
     */
    boolean update(OwnAdvertReqDto ownAdvertReqDto);

    /**
     * 删除自持广告
     */
    boolean delete(OwnAdvertDeleteReqDto ownAdvertDeleteReqDto);

}
