/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.enums.ChangeTradeCode;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ChangeIncomeCode implements ChangeTradeCode
{
    SETTLE(1, "\u91d1\u5e01\u5151\u6362\u73b0\u91d1"),
    NEW_USER_REWARD(2, "\u65b0\u7528\u6237\u5956\u52b1"),
    SIGN_IN(3, "\u7b7e\u5230\u5956\u52b1"),
    WITHDRAW_TURN_DOWN(4, "\u63d0\u73b0\u9000\u8fd8\u5165\u8d26"),
    INVITE_INCOME(5, "\u9080\u8bf7\u597d\u53cb"),
    LIMIT_PECKET(6, "\u9650\u65f6\u7ea2\u5305"),
    NEW_TICKET_WITHDRAW(7, "\u9996\u6b21\u63d0\u73b0\u6210\u529f"),
    LUCK_PACKET_SEND(8, "\u7ea2\u5305\u6536\u76ca"),
    LUCK_PACKET_RECEIVE(9, "\u9886\u53d6\u7ea2\u5305"),
    POINT_PACKET(10, "\u75af\u72c2\u62bd\u5956"),
    NEW_USER_READING(11, "\u9605\u8bfb\u6587\u7ae0\u5956\u52b1"),
    NEW_USER_DRAWED(12, "\u6536\u53d6\u7ea2\u5305\u5956\u52b1"),
    NEW_PLAN_DRAWED(13, "\u6536\u53d6\u7ea2\u5305\u5956\u52b1"),
    SALE_TRIBUTE_SETTLE(14, "\u56e2\u961f\u8fdb\u8d21\u7ed3\u7b97"),
    SALE_OWN_SETTLE(15, "\u76f4\u5c5e\u4f63\u91d1\u7ed3\u7b97"),
    LOGIN_REWARD_LOGIN(16, "\u65b0\u624b\u4efb\u52a1:\u767b\u9646"),
    LOGIN_REWARD_READ(17, "\u65b0\u624b\u4efb\u52a1:\u9605\u8bfb");

    private Integer code;
    private String desc;
    private static final Map<Integer, ChangeIncomeCode> CACHE;
    public static final Set<Integer> CODE_IN_TASK;

    private ChangeIncomeCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public static ChangeIncomeCode get(Integer code) {
        return CACHE.get(code);
    }

    public static boolean codeInTask(Integer code) {
        return CODE_IN_TASK.contains(code);
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(ChangeIncomeCode.values()), ChangeIncomeCode::getCode);
        CODE_IN_TASK = Stream.of(ChangeIncomeCode.SIGN_IN.code, ChangeIncomeCode.INVITE_INCOME.code, ChangeIncomeCode.LIMIT_PECKET.code, ChangeIncomeCode.LUCK_PACKET_SEND.code, ChangeIncomeCode.POINT_PACKET.code, ChangeIncomeCode.NEW_USER_READING.code, ChangeIncomeCode.NEW_USER_DRAWED.code, ChangeIncomeCode.NEW_PLAN_DRAWED.code).collect(Collectors.toSet());
    }
}

