/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums.loginReward;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum LoginRewardEnum {
    LOGIN(1, "\u767b\u9646\u5929\u5929\u8da3\u95fb", 1L),
    READ(2, "\u9605\u8bfb5\u7bc7\u6587\u7ae0", 5L),
    PLANT(3, "\u79cd\u690d3\u4e2a\u7ea2\u5305", 3L);

    private Integer taskId;
    private String taskDescription;
    private Long allPlan;
    private static final Map<Integer, LoginRewardEnum> CACHE;

    private LoginRewardEnum(Integer taskId, String taskDescription, Long allPlan) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
        this.allPlan = allPlan;
    }

    public Integer getTaskId() {
        return this.taskId;
    }

    public Long getAllPlan() {
        return this.allPlan;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public static LoginRewardEnum getByTaskId(Integer taskId) {
        LoginRewardEnum rewardTaskType = CACHE.get(taskId);
        if (rewardTaskType != null) {
            return rewardTaskType;
        }
        return LOGIN;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(LoginRewardEnum.values()), LoginRewardEnum::getTaskId);
    }
}

