package cn.com.duiba.tuia.news.center.dto;

import cn.com.duiba.tuia.news.center.enums.UserLoginType;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: WechatLoginAuthDto.java , v 0.1 2017/12/28 下午3:52 ZhouFeng Exp $
 */
public class WechatLoginAuthDto extends LoginAuthDto {

    private static final UserLoginType LOGIN_TYPE = UserLoginType.WECHAT;
    private static final long serialVersionUID = 189903311568129775L;

    private String openId;


    private String realOpenId;

    private String accessToken;

    public WechatLoginAuthDto(String openId) {
        this.openId = openId;
    }


    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getRealOpenId() {
        return realOpenId;
    }

    public void setRealOpenId(String realOpenId) {
        this.realOpenId = realOpenId;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Override
    public UserLoginType getLoginType() {
        return LOGIN_TYPE;
    }
}
