package cn.com.duiba.tuia.news.center.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 合作伙伴职业枚举
 *
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: Profession.java , v 0.1 2018-11-27 13:47 ElinZhou Exp $
 */
public enum Profession {


    WORKER("上班族", 1),

    STUDENT("学生", 2),

    MOTHER("宝妈", 3),

    MICRO_BUSINESSMAN("微商", 4),

    UNEMPLOYED("无业人士", 5),

    RETIRED("退休人士", 6),

    OTHER("其他", 7),


    ;

    private String desc;
    private Integer code;

    private static final Map<Integer, Profession> CACHE =
            Arrays.stream(values()).collect(Collectors.toMap(Profession::getCode, e -> e));


    Profession(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    /**
     * 通过code获取枚举
     *
     * @param code
     * @return
     */
    public static Profession of(Integer code) {
        return CACHE.get(code);
    }
}


