package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.WithdrawTicketDto;

import java.util.List;

/**
 * Created by xiaotian on 2018/4/17.
 */
@AdvancedFeignClient
public interface RemoteWithdrawTicketService {

    /**
     * 获取特权券
     * @param userId
     * @param source
     * @param fee
     * @return
     */
    boolean getTicket(Long userId,Integer source,Long fee) throws BizException;

    /** 直接获取1元券，不允许线上调用 */
    boolean getTicketNative(Long userId, Integer source, Long fee) throws BizException;

    /**
     * 查询特权券
     * @param userId
     * @param source
     * @param fee
     * @return
     */
    Integer getTicketCount(Long userId,Integer source,Long fee,Integer status);

    /**
     * 获取可用的提现券（特权券+日常券）
     * @param userId
     * @return
     */
    List<WithdrawTicketDto> getPacketTicket(Long userId) throws BizException;

    /**
     * 获取可用的提现券（特权券+日常券）
     * @param userId
     * @return
     */
    List<WithdrawTicketDto> getPacketTicketV2(Long userId) throws BizException;

    /**
     * 获取可用的提现券（特权券+日常券）
     * @param userId
     * @return
     */
    List<WithdrawTicketDto> getPacketTicketV6(Long userId) throws BizException;

    /**
     * 判断是否领取过该类型的
     * @param userId
     * @param source
     * @param fee
     * @return
     */
    Boolean hasgotTicket(Long userId,Integer source,Long fee);


    /**
     * 除了第一张特权券之外的获取特权券接口
     * @param userId
     * @param source
     * @param fee
     * @return
     */
    Boolean getSpecialTicketExceptFrist(Long userId,Integer source,Long fee) throws BizException ;

    /**
     * 获取用户一元提现券获取进度
     * @param userId
     * @return
     */
    int getTicketProgress(Long userId);

}
