package cn.com.duiba.tuia.news.center.enums;

/**
 * @author ElinZhou
 * @version $Id: WithdrawType.java , v 0.1 2018/1/2 下午6:01 ElinZhou Exp $
 */
public enum WithdrawType {


    /**
     * 零钱提现
     */
    CHANGE_WITHDRAW(1),;


    private Integer code;

    WithdrawType(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    public static WithdrawType of(Integer aCode) {
        if (aCode == null) {
            return null;
        }
        for (WithdrawType withdrawType : values()) {
            if (withdrawType.getCode().equals(aCode)) {
                return withdrawType;
            }
        }
        return null;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);

    }
}
