package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.plan.MissionEventDto;
import cn.com.duiba.tuia.news.center.dto.req.UserAccountCenter;
import cn.com.duiba.tuia.news.center.dto.rsp.MissionDetailDto;

import java.util.List;

/**
 * 1.6.2 之后的任务相关接口
 *
 * @author lichao 2018/11/16
 */
@AdvancedFeignClient
public interface RemoteMissionService {

    /**
     * 查询当前用户的任务列表
     * @param userAccountCenter 用户信息
     * @return
     */
    List<MissionDetailDto> findMissionList(UserAccountCenter userAccountCenter);

    /**
     * 进行执行任务
     * @param request 任务的参数
     * @return 返回任务详情和任务进度 当为null时表示当前么有任务可执行
     */
    MissionDetailDto doEvent(MissionEventDto request);

    /**
     * 任务领取
     * @param missionId 任务id
     * @param userAccountCenter 用户
     * @return 任务详情
     */
    MissionDetailDto receive(Long missionId,UserAccountCenter userAccountCenter);


}
