package cn.com.duiba.tuia.news.center.enums.loginReward;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 土地任务
 */
public enum LoginRewardEnum {

    LOGIN(1, "登录天天趣闻", 1L),

    READ(2, "阅读5篇文章", 5L),

    PLANT(3, "种植3个红包", 3L),

    TREE(4, "种植摇钱树", 1L),
    ;

    /**
     * 任务ID
     */
    private Integer taskId;

    /**
     * 任务描述
     */
    private String taskDescription;

    /**
     * 达标值
     */
    private Long allPlan;

    private static final Map<Integer, LoginRewardEnum> CACHE = Maps.uniqueIndex(Arrays.asList(LoginRewardEnum.values()),
            LoginRewardEnum::getTaskId);

    LoginRewardEnum(Integer taskId, String taskDescription, Long allPlan) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
        this.allPlan = allPlan;
    }

    public Integer getTaskId() {
        return taskId;
    }

    public Long getAllPlan() {
        return allPlan;
    }

    public String getTaskDescription() {
        return taskDescription;
    }

    public static LoginRewardEnum getByTaskId(Integer taskId) {
        LoginRewardEnum rewardTaskType = CACHE.get(taskId);
        if (rewardTaskType != null) {
            return rewardTaskType;
        }
        return LOGIN;
    }
}
