package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.AccountBalanceDto;
import cn.com.duiba.tuia.news.center.dto.AccountDetailDto;
import cn.com.duiba.tuia.news.center.dto.UserDailyIncomeCoinsDto;
import cn.com.duiba.tuia.news.center.dto.rsp.AccountBalanceV2Dto;
import cn.com.duiba.tuia.news.center.dto.tryplay.TryPlayDto;

import java.util.List;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteAccountService.java , v 0.1 2018/1/3 下午2:18 ZhouFeng Exp $
 */
@AdvancedFeignClient
public interface RemoteTryPlayService {


    /**
     * 插入试玩记录
     * @return
     */
    TryPlayDto insertRecord(TryPlayDto tryPlayDto);

    /**
     * 根据userId 查询试玩列表
     */
    List<TryPlayDto> selectByUserId(Long userId);

    /**
     * 更新下载完成状态
     */
    boolean updateDownloadStatus(TryPlayDto tryPlayDto);

    /**
     * 更新奖励领取状态
     */
    boolean updateRewardStatus(TryPlayDto tryPlayDto);


    /**
     * 根据userId 与 包名查找
     */
    TryPlayDto selectByUserIdAndPackage(Long userId, String packageName);


    /**
     * 打开app应用,更新应用的奖励状态
     */
    TryPlayDto updateRewardingStatus(TryPlayDto tryPlayDto);



}
