package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.xcx.VisitRewardRsp;
import cn.com.duiba.tuia.news.center.dto.xcx.WechatUserStatus;
import cn.com.duiba.tuia.news.center.dto.xcx.WechatXcxUserAccountDto;
import cn.com.duiba.tuia.news.center.dto.xcx.WechatXcxUserDto;

/**
 * 微信小程序相关api
 */
@AdvancedFeignClient
public interface RemoteWechatXcxService {

    boolean isNewUser(WechatXcxUserDto wechatXcxUserDto);

    boolean isNewUserNotCreate(WechatXcxUserDto wechatXcxUserDto);

    void createAcount4OldUser(String openId);

    /**
     * 回访奖励接口
     *
     * @param shareOpenId 分享者
     * @param visitOpenId 回访者
     * @param artId       文章ID
     */
    void shareVisit(String shareOpenId, String visitOpenId, Long artId);

    /**
     * 文章分享接口
     *
     * @param shareOpenId 分享者
     * @param artId       文章ID
     */
    Long share(String shareOpenId, Long artId);

    /**
     * 获取用户分享回访奖励
     *
     * @param openId
     * @return
     */
    VisitRewardRsp rewardInfo(String openId);

    /**
     * 获取用户账户信息
     *
     * @param openId
     * @return
     */
    WechatXcxUserAccountDto userAccountInfo(String openId);

    /**
     * 用户授权接口
     * 首次授权发送金币奖励
     *
     * @param openId
     * @return
     */
    public Long userAuthAndReward(String openId);

    /**
     * 获取用户状态
     *
     * @param openId
     * @return
     */
    public WechatUserStatus getUserStatus(String openId);
}
