package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @author wsz
 * @date 2018/12/10 11:12
 */
public enum ShortMessageType {
    INVITE_MSG(1,"邀请短信"),
    INVITE_REMIND(2,"邀请提醒短信"),
    ;
    private Integer type;
    private String desc;

    private static final Map<Integer,ShortMessageType> CACHE = Maps.uniqueIndex(Arrays.asList(ShortMessageType.values()),ShortMessageType :: getType);

    ShortMessageType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ShortMessageType getByType(Integer type) {
        return CACHE.get(type);
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
