package cn.com.duiba.tuia.news.center.enums;

/**
 * @author ElinZhou
 * @version $Id: ErrorCode.java , v 0.1 2017/12/28 下午3:24 ElinZhou Exp $
 */
public enum TagCode {

    LAND_TAG(1,"landTag"),
    ADD_REWARD_TAG(2,"addRewardTag"),
    NEW_INVITE_TAG(3,"newInviteTag"),
    NEW_LAND_TAG(4,"newLandTag"),

    /**
     * 金币流水消息
     */
    COIN_ORDER(5,"coinOrder"),

    /**
     * 零钱流水消息
     */
    CHANGE_ORDER(6,"changeOrder"),

    /**
     * 拼手气红包新人登陆结算
     */
    LUCK_PACKET(7,"luckPacket"),

    /**

     * 现金红包领取
     */
    CASH_PACKET(8,"cashPacket"),

    /*
     * 活动带入新人发消息给quwen_center
     */
    NEW_USER_FOR_FUN(9,"newUserForFun"),

    /**
     * 用户行为
     */
    USER_ACTION_RECORD(10,"userActionRecord"),

    /**
     * fun-center活动奖励
     */
    FUN_ACTIVITY_REWARD(11,"funActivityReward"),

    /**
     * 活动引流发消息给quwen_center
     */
    DRAINAGE_FOR_FUN(12,"drainageForFun"),

    /**
     * 用户活动收益增加成功
     */
    FUN_ACTIVITY_REWARD_ADD(13,"funActivityRewardAdd"),
    ;

    private Integer code;

    private String description;

    TagCode(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

}
