package cn.com.duiba.tuia.news.center.enums;

import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 * 安卓推送自定义通知的enum
 *
 * 具体参数详情请参考:http://cf.dui88.com/pages/viewpage.action?pageId=11541077
 * @author lichao 2018/11/28
 */
public enum AndroidPushCustomEnum {

    /** 收益到账,我的tab */
    SHOUYI("CUSTOM_SHOUYI","/main/home","tiantianquwen://router/main/home","com.ttyouqu.app.module.MainActivity"),//ext_info 中为{"id"=4}

    /** 提现详情页 */
    CASH_SUCESS("CUSTOM_CASH_SUCESS","/act/request_cash_detail","tiantianquwen://router/act/request_cash_detail","com.ttyouqu.app.ui.activity.RequestCashDetailActivity"),

    /*直属分销进帐*/
    SALE_OWN_SETTLE("SALE_OWN_SETTLE","/act/partner_income_details","tiantianquwen://router/act/partner_income_details","com.ttyouqu.app.ui.activity.PartnerIncomeDetailsActivity"),

    /*进贡分销进帐*/
    SALE_UP_SETTLE("SALE_UP_SETTLE","/act/partner_income_details","tiantianquwen://router/act/partner_income_details"
            ,"com.ttyouqu.app.ui.activity.PartnerIncomeDetailsActivity"),

    PARTNER_CENTER("PARTNER_CENTER","/act/partner","tiantianquwen://router/act/partner","com.ttyouqu.app.ui.activity" +
            ".PartnerActivity"),

    /** 通用h5页面 */
    COMMON_H5("COMMON_H5","/web/commweb","tiantianquwen://router/web/commweb","com.ttyouqu.app.ui.activity.HWPushActivity"),
    /** 邀请好友*/
    INVITE("INVITE","/mine/invite","tiantianquwen://router/mine/invite","com.ttyouqu.app.ui.activity.HWPushActivity"),
    /** 推送文章*/
    ARTICLE("ARTICLE","/article/article_detail","tiantianquwen://router/article/article_detail","com.ttyouqu.app.ui.activity.HWPushActivity"),
    /** 推送视频*/
    VIDEO("VIDEO","/vide/detail_v3","tiantianquwen://router/vide/detail_v3","com.ttyouqu.app.ui.activity.HWPushActivity")
    ;

    AndroidPushCustomEnum(String type,String jumpCode,String jumpUrl, String activityUrl) {
        this.type = type;
        this.jumpCode = jumpCode;
        this.jumpUrl = jumpUrl;
        this.activityUrl = activityUrl;
    }

    private String type;

    private String jumpCode;//安卓跳转的code

    private String jumpUrl;//安卓的跳转页面

    private String activityUrl;

    public static AndroidPushCustomEnum getByType(String type){
        if(StringUtils.isBlank(type)){
            return null;
        }

        for(AndroidPushCustomEnum enums : AndroidPushCustomEnum.values()){
            if(Objects.equals(enums.getType(),type)){
                return enums;
            }
        }
        return null;

    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getActivityUrl() {
        return activityUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public String getJumpCode() {
        return jumpCode;
    }

    public void setJumpCode(String jumpCode) {
        this.jumpCode = jumpCode;
    }
}
