package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 提现券种类
 * 1.6.2版本新增
 */
public enum WithdrawTicketEnumV6 {
    /**
     * 1元
     */
    ONE(100L,1,"1元"),

    /**
     * 10元
     */
    TEN(1000L,0,"10元"),

    /**
     * 1.6.2版本新增
     * 20元
     */
    TWENTY(2000L,0,"20元"),

    /**
     * 30元
     */
    THIRTY(3000L,0,"30元"),

    /**
     * 50元
     */
    FIFTY(5000L,0,"50元"),

    /**
     * 100元
     */
    ONE_HUNDRED(10000L,0,"100元"),

    ;
    private static final Map<Long, WithdrawTicketEnumV6> CACHE = Maps.uniqueIndex(Arrays.asList(WithdrawTicketEnumV6
            .values()), WithdrawTicketEnumV6::getFee);

    private Long fee;
    /**
     * 0:非特权券  1：特权券
     */
    private Integer type;
    private String desc;

    WithdrawTicketEnumV6(Long fee, Integer type, String desc) {
        this.fee = fee;
        this.type = type;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Long getFee() {
        return fee;
    }

    public Integer getType() {
        return type;
    }

    public static WithdrawTicketEnumV6 of(Long fee) {
        return CACHE.get(fee);
    }

}
