package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.downloadconfig.DownloadAppConfigDto;
import cn.com.duiba.tuia.news.center.dto.firstscreen.FirstScreenAdDto;
import cn.com.duiba.tuia.news.center.dto.req.firstscreen.FirstScreenAdReqDto;
import cn.com.duiba.tuia.news.center.dto.req.firstscreen.LaunchSortReqDto;
import cn.com.duiba.tuia.news.center.dto.req.firstscreen.OwnAdvertDeleteReqDto;
import cn.com.duiba.tuia.news.center.dto.req.firstscreen.OwnAdvertReqDto;
import cn.com.duiba.tuia.news.center.dto.req.firstscreen.OwnAdvertSortReqDto;

import java.util.List;

/**
 * @author zhou_wb
 * 需求变动，临时处理返回固定
 */
@AdvancedFeignClient
public interface RemoteDownLoadConfigService {

    /**
     *添加与保存配置
     */
    boolean save(DownloadAppConfigDto downloadAppConfigDto);

    /**
     * 获取所有配置信息（后台）
     * @return
     */
    List<DownloadAppConfigDto> selectByAllForBk();


    /**
     * 获取所有配置（非后端）
     */
    List<DownloadAppConfigDto> selectAll();

    /**
     * 更新排序
     * @param
     */
    void updateAppSort(List<Long> ids);


    /**
     *更新开启状态
     */
    boolean updateAppEnableStatus(Integer status, Long id);


    /**
     *删除配置
     */
    boolean delete(Long id);

    /**
     * 根据id查询信息
     */
    DownloadAppConfigDto selectById(Long id);
}
