package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.req.InviteRecordDto;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteInviteRecordService {

    /**
     * 根据被邀请人 id 获取邀请记录
     * 
     * @param inviteeId 被邀请人 id
     * @return 邀请记录
     */
    InviteRecordDto getByInviteeId(Long inviteeId);


    /**
     * 根据用户的Id获取该用户已经绑定的邀请码
     * @param inviteeId
     * @return
     */
    String getCodeByInviteeId(Long inviteeId);

    /**
     * 根据邀请人 id 获取邀请记录
     *
     * @param inviterId 邀请人 id
     * @return 邀请记录
     */
    List<InviteRecordDto> getByInviterId(Long inviterId);

    /**
     * 新增邀请关系，for fun-center 新春送财神活动
     * @param inviteeId 被邀请者
     * @param inviterId 邀请者
     * @return
     */
    Boolean update(Long inviteeId, Long inviterId);

    /**
     * 新增邀请关系,for 全民大拜师
     * @param inviteRecordDto
     * @return
     */
    boolean update4Act(InviteRecordDto inviteRecordDto);

    /**
     * 查询用户指定日志之后的邀请记录
     * @param inviterId 邀请者ID
     * @param date 指定日期
     * @return
     */
    List<InviteRecordDto> listAfterDate(Long inviterId, Date date);

    /**
     * 查询用户历史邀请人数
     *
     * @param userId
     * @return
     */
    int countInvite(Long userId);

    /**
     * 根据邀请者id列表查询邀请记录，注意数据量，慎用！！！
     * @param userIds
     * @return
     */
    List<InviteRecordDto> listByInviterIds(List<Long> userIds);
}
