package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 审核状态
 *
 * @author ElinZhou
 * @version $Id: ApplyStatus.java , v 0.1 2018/1/2 下午3:50 ElinZhou Exp $
 */
public enum TicketGetStatus {
    /**
     * 不可领取（没有完成签到任务）
     */
    CAN_NOT_GET(-1,"不可领取"),

    /**
     * 可领取（可以领取，签到任务已经完成）
     */
    CAN_GET(0,"可领取"),

    /**
     * 已经领取（没有提现）
     */
    GET_NOT_USE(1,"已经领取还没有提现"),

    /**
     * 领取并且提现
     */
    GET_AND_USE(2,"领取并且提现"),

    ;
    private static final Map<Integer, TicketGetStatus> CACHE = Maps.uniqueIndex(Arrays.asList(TicketGetStatus
            .values()), TicketGetStatus::getCode);

    private Integer code;
    private String desc;

    TicketGetStatus(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);
    }

    public static TicketGetStatus of(Integer aCode) {
        return CACHE.get(aCode);
    }

}
