package cn.com.duiba.tuia.news.center.remoteservice;

import java.util.Date;
import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.InviteChangeDto;
import cn.com.duiba.tuia.news.center.dto.InviteRewardNewDto;
import cn.com.duiba.tuia.news.center.dto.InviteRewardTotalDto;
import cn.com.duiba.tuia.news.center.dto.req.InviteRewardDto;
import cn.com.duiba.tuia.news.center.dto.req.ShareInviteDto;

@AdvancedFeignClient
public interface RemoteInviteRewardService {

    /**
     * 根据用户 id 获取被邀请用户奖励列表
     * 
     * @param userId 用户 id
     * @return 被邀请用户奖励列表
     */
    List<InviteRewardDto> list(Long userId);


    /**
     * 未获取的奖励金总额
     * @param userId
     * @return
     */
    Long unGetRewardCount(Long userId);

    /**
     * 已获取的奖励金总额
     * @param userId
     * @return
     */
    Long getRewardCount(Long userId);

    /**
     * 领取未领取的奖励金
     * @param userId
     * @return
     */
    Long getInviteReward(Long userId);

    /**
     *最新的邀请好友奖励金领取记录
     * @param
     * @return
     */
    List<InviteChangeDto> getInviteChangeList(Long pageNo, Long pageSize);


    /**
     * 获取邀请人的好友列表
     * @param userId
     * @param pageNo
     * @param pageSize
     * @return
     */
    List<InviteRewardNewDto> getInviteList(Long userId, Integer pageNo, Integer pageSize);


    /**
     * 获取是否有新的待唤醒的好友
     */
    boolean hasNewWaitAwakenFriends(Long userId);


    /**
     * 获取随机分享
     * @param userId
     * @return
     */
    ShareInviteDto getInviteShowContent(Long userId);

    /**
     * 获取日期范围内的邀请数据
     * @param date
     * @return
     */
    List<InviteChangeDto> getListFromDateTime(Date date);

    /**
     * 获取日期范围内邀请人个数
     * @return
     */
    List<InviteRewardDto> listInviteRewardByDate(Date date);


    /**
     * 根据邀请人Id获取奖励数据
     * @param inviterId
     * @return
     */
    InviteRewardTotalDto getInviteRewardTotal(Long inviterId);

    /**
     * 查询时间段内用户进贡数据
     * @param inviterId
     * @param start
     * @param end
     * @return
     */
    InviteRewardTotalDto getListByInviterIdAndDate(Long inviterId, Date start, Date end);

}
