package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.CashPacketDto;
import cn.com.duiba.tuia.news.center.dto.DailyTaskDto;
import cn.com.duiba.tuia.news.center.dto.ReadWatchRewardDetailDto;
import cn.com.duiba.tuia.news.center.dto.ReadingRewardDto;
import cn.com.duiba.tuia.news.center.dto.ReceiveNewUserRewardDto;
import cn.com.duiba.tuia.news.center.dto.req.*;
import cn.com.duiba.tuia.news.center.dto.rsp.BeInvitedTaskCompleteDto;
import cn.com.duiba.tuia.news.center.dto.rsp.ReadingTaskCompleteDto;
import cn.com.duiba.tuia.news.center.dto.rsp.WatchingTaskCompleteDto;
import cn.com.duiba.tuia.news.center.enums.IconHintContentEnum;

import java.util.List;
import java.util.Map;


/**
 * @author ElinZhou
 * @version $Id: RemoteRewardTaskService.java , v 0.1 2018/1/3 上午11:41 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteRewardTaskService {
    /**
     * 完成阅读（不维护了，若调用，后果自负）
     * @param userId 用户id
     * @param newsId 新闻id
     * @return 完成阅读任务返回
     */
    @Deprecated
    ReadingTaskCompleteDto readingComplete(Long userId, String newsId) throws BizException;

    /**
     * 完成阅读（不维护了，若调用，后果自负）
     * @param userId 用户id
     * @param newsId 新闻id
     * @return 完成阅读任务返回
     */
    @Deprecated
    ReadingTaskCompleteDto readingCompleteV2(Long userId, String newsId) throws BizException;

    /**
     * 完成阅读
     * @param readingCompleteReq
     * @return
     * @throws BizException
     */
    ReadingTaskCompleteDto readingCompleteV3(ReadingCompleteReq readingCompleteReq) throws BizException;


    /**
     * 完成阅读(1.6.1根据阅读时长更改获取奖励的逻辑)
     * @param readingCompleteReq
     * @return
     * @throws BizException
     */
    ReadingTaskCompleteDto readingCompleteV4(ReadingCompleteReq readingCompleteReq) throws BizException;


    /**
     * 完成观看
     *
     * @param userId 用户id
     * @param videoId 视频id
     * @return 完成观看视频任务返回
     */
    WatchingTaskCompleteDto watchingComplete(Long userId, String videoId) throws BizException;

    /**
     * 完成观看
     *
     * @param userId 用户id
     * @param videoId 视频id
     * @return 完成观看视频任务返回
     */
    WatchingTaskCompleteDto watchingCompleteV2(Long userId, String videoId) throws BizException;

    WatchingTaskCompleteDto watchingCompleteV3(ReadingCompleteReq req) throws BizException;


    /**（线上转用50篇文章奖励上线，这个判断已经废弃）
     * 判断该用户是否完成今日阅读任务(今日阅读奖励全部获得)
     * @param userId 用户id
     * @return 完成情况 true-全部完成 false-未完成
     */
    @Deprecated
    Boolean isTodayReadingTaskDone(Long userId);

    /**
     * 判断该用户是否完成今日阅读任务(今日阅读奖励全部获得)
     * @param userId 用户id
     * @return 完成情况 true-全部完成 false-未完成
     */
    Boolean isTodayReadingTaskDoneV2(Long userId);
    /**
     * 判断该用户是否完成今日阅读任务(今日阅读奖励全部获得)
     * @return 完成情况 true-全部完成 false-未完成
     */
    Boolean isTodayReadingTaskDoneV3(ReadingCompleteReq readingCompleteReq);

    /**
     * 判断该用户是否完成今日视频阅读任务(今日阅读奖励全部获得)
     * @return 完成情况 true-全部完成 false-未完成
     */
    Boolean isTodayWatchingTaskDoneV3(ReadingCompleteReq readingCompleteReq);


    /**（线上转用50篇文章奖励上线，这个判断已经废弃）
     * 该篇新闻是否有阅读奖励
     * @param userId 用户id
     * @param newsId 新闻id
     * @return true-有 false-无
     */
    @Deprecated
    Boolean hasReadingReward(Long userId,String newsId);

    /**
     * 该篇新闻是否有阅读奖励
     * @param userId 用户id
     * @param newsId 新闻id
     * @return true-有 false-无
     */
    @Deprecated
    Boolean hasReadingRewardV2(Long userId,String newsId);

    Boolean hasReadingRewardV3(ReadingCompleteReq req);

    /**
     * 单篇文章可以获取两次奖励
     * @param req
     * @return
     */
    Boolean hasReadingRewardV4(ReadingCompleteReq req);

    /**（线上转用50篇文章奖励上线，这个判断已经废弃）
     * 该视频是否有观看奖励
     * 
     * @param userId 用户id
     * @param videoId 视频id
     * @return true-有 false-无
     */
    @Deprecated
    Boolean hasWatchingReward(Long userId, String videoId);

    /**
     * 该视频是否有观看奖励
     *
     * @param userId 用户id
     * @param videoId 视频id
     * @return true-有 false-无
     */
    @Deprecated
    Boolean hasWatchingRewardV2(Long userId, String videoId);

    Boolean hasWatchingRewardV3(ReadingCompleteReq req);




    /**
     * 签到V3接口
     * @return
     */
    SignInResultDto signv3(SignReq signReq) throws BizException;

    /**
     * 签到V4接口
     * @return
     */
    SignInResultDto signv4(SignReq signReq) throws Exception;

    /**
     * 签到V4接口
     * @return
     */
    SignInResultDto signv5(SignReq signReq) throws Exception;

    /**
     * 1.6.2之后的签到接口
     * 只返回签到成功还是失败
     */
    boolean signv6(SignV6Req signV6Req) throws Exception;

    /**
     * 签到
     * @param userId 用户id
     * @return 签到结果
     */
    SignInResultDto signInV2(Long userId) throws BizException;

    /**
     * 签到
     * @param userId 用户id
     * @return 签到结果
     */
    SignInResultDto signIn(Long userId) throws BizException;


    /**
     * 输入邀请码接口(被邀请)
     * 
     * @param userId 用户 id
     * @param inviteCode 邀请码
     * @return 邀请结果
     */
    BeInvitedTaskCompleteDto beInvited(Long userId, String inviteCode) throws BizException;


    /**
     * 根据userId获取今天已经阅读的参数
     * @param userId
     * @return
     */
    Integer getPresentReadNumber(Long userId);

    /**
     * 领取新人引导奖励
     * @param receiveNewUserRewardReq
     * @return
     */
    ReceiveNewUserRewardDto receiveNewUserReward(ReceiveNewUserRewardReq receiveNewUserRewardReq) throws BizException;

    /**
     * 获取用户每日任务列表
     * @param userId  用户id
     * @param version 版本号
     * @return
     */
    List<DailyTaskDto> getDailyTaskList(Long userId, Integer version) throws BizException;

    /**
     * 获取气泡提示文案
     * @param userId
     * @return
     */
    IconHintContentEnum getIconHint(Long userId);


    /**
     * 获取奖励列表
     * @param userId
     * @return
     */
    List<ReadingRewardDto> getReadRewardList(Long userId);


    /**
     * 获取奖励详情
     * @param userId
     * @return
     */
    ReadWatchRewardDetailDto  readWatchRewardDetail(Long userId,String version);

    /**
     * 获取视频和阅读奖励
     * @param userId
     * @return
     */
    ReadingRewardDto getAllRewardList(Long userId);

    /**
     * 获取用户阅读奖励
     * 注意userIds的长度
     * @param userIds
     * @return
     */
    Map<Long,Integer> listReadRewardByUserIds(List<Long> userIds);

}
