package cn.com.duiba.tuia.news.center.util;

import cn.com.duiba.tuia.news.center.enums.AndroidPushNotificationEnum;
import cn.com.duiba.tuia.news.center.pojo.AndroidPushNotificationPoJo;
import cn.com.duiba.tuia.news.center.pojo.JiGuangPushPoJo;
import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.device.TagAliasResult;
import cn.jpush.api.push.CIDResult;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.audience.AudienceTarget;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.report.MessagesResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

import java.util.*;

/**
 * Created by zhou_wb on 2018/4/27.
 */
@Configuration
public class JiGuangPushUtils {

    private static Logger logger = LoggerFactory.getLogger(JiGuangPushUtils.class);

    private static String masterSecret;

    private static String appKey;

    private static boolean jiGuangSwitch;

    public static void setMasterSecret(String masterSecret) {
        JiGuangPushUtils.masterSecret = masterSecret;
    }

    public static void setAppKey(String appKey) {
        JiGuangPushUtils.appKey = appKey;
    }

    public static void setJiGuangSwitch(boolean jiGuangSwitch) {
        JiGuangPushUtils.jiGuangSwitch = jiGuangSwitch;
    }

    public static String URL_MAIN_ACTIVITY = "com.ttyouqu.app.module.MainActivity";

    public static String URL_WALLET_ACTIVITY = "com.ttyouqu.app.module.WalletActivity";

    //public static String URL_INVITE_ACTIVITY = "com.ttyouqu.app.module.frggame.actinvite.InviteActivity";
    public static String URL_INVITE_ACTIVITY = "com.ttyouqu.app.ui.activity.HWPushActivity";


    public static String URL_LIMIT_PACKET_ACTIVITY = "com.ttyouqu.app.module.frggame.acttimeredpacket.TimeRedPacketActivity";

    public static String URL_LUCK_PACKET_ACTIVITY = "com.ttyouqu.app.module.actgroupredpacket.GroupRedPacketActivity";



    public static String TODAY_READ_TITLE = "您有一笔新增收益！";

    public static String TODAY_READ_ALERT = "收益已到账，点击立即提现>>";

    public static String TODAY_SIGN_TITLE = "【1条未读消息】";

    public static String TODAY_SING_ALERT = "你今日还有现金待领取，看资讯轻松赚钱，每日无上限哦~";

    public static String DIS_RED_PACK_TITLE = "现金红包待领取";

    public static String DIS_RED_PACK_ALERT = "今天的现金红包还未领取，时间有限，先领先得>>";

    public static String RECALL_TITLE = "现金红包限时免费领取";

    public static String RECALL_ALERT = "时间有限，先领先得>>";

    public static String VERSION_TAG = "VERSION_1.2.3";

    public static String LAND_PACKET_TITLE = "红包收取提醒";

    public static String LAND_PACKET_ALERT = "你的红包已成熟，再不收取就没啦~点击收取>>";


    public static String LIMIT_PACKET_HELP_TITLE = "好友帮拆成功，你获得一个新红包！";

    public static String LIMIT_PACKET_HELP_ALERT = "你的好友帮你拆了限时红包，帮拆进度已更新，快来看看 >>";

    public static String INVITE_SUCCESS_TITLE = "恭喜获得一笔现金奖励！";

    public static String INVITE_SUCCESS_ALERT = "你的好友绑定了你的邀请码，好友阅读后即可拿到现金奖励 >>";

    public static String RED_POINT_CONTENT = "redPoint";

    public static String INVITE_CHANGE_REWARD_CONTENT = "inviteChangeReward";

    public static String DOUBLE_PACKET_TITLE = "{{%s}}为你助力成功";

    public static String DOUBLE_PACKET_ALERT = "当前翻倍{{%s}}，快戳进来看看";

    public static String LUCK_PACKET_SEND_IN_TITLE = "群红包收益提醒";

    public static String LUCK_PACKET_SEND_IN_ALERT = "有钱入账了，快去看看！";

    public static String LUCK_PACKET_SEND_WAIT_TITLE = "群红包收益提醒";

    public static String LUCK_PACKET_SEND_WAIT_ALERT = "你有收益待入账，快去催一下！";


    public static String WAKE_TO_PICK_1_TITLE = "/";

    public static String WAKE_TO_PICK_1_ALERT = "您的红包已经成熟，再不收取就要被人偷完啦！点击收取>>";


    public static String WAKE_TO_PICK_2_TITLE = "收红包啦！";

    public static String WAKE_TO_PICK_2_ALERT = "您的红包已成熟，再不收取就要被偷啦！点击收取>>";


    public static String POINT_PACKET_TITLE = "恭喜";

    public static String POINT_PACKET_ALERT = "您获得了新的抽奖机会！快去抽奖！";

    public static String ACTIVITY_REWARD_TITLE = "有新的金币收益啦，快去看看！";
    public static String ACTIVITY_REWARD_ALERT = "有新的金币收益啦，快去看看！";

    public static String ACTIVITY_SET_TITLE = "有金币收益未领取，再不来就晚啦！";
    public static String ACTIVITY_SET_ALERT = "有金币收益未领取，再不来就晚啦！";

    public static String ONE_CASH_WITHDRAW_TITLE = "恭喜您成为本月幸运用户！！！";
    public static String ONE_CASH_WITHDRAW_ALERT = "获得1元提现特权，点击立刻提现 >>";

    public static void setDeviceTag(JiGuangPushPoJo jiGuangPushPoJo) throws APIConnectionException, APIRequestException {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        jpushClient.updateDeviceTagAlias(jiGuangPushPoJo.getRegistrationId(),null,jiGuangPushPoJo.getAddTages(),jiGuangPushPoJo.getRemoveTags());
        jpushClient.close();
    }

    /**
     * 批量打标签
     * @param tag 标签
     * @param addRegIds  添加的regIds
     * @param removeRegIds 移除的regIds
     * @throws APIConnectionException
     * @throws APIRequestException
     */
    public static void addRemoveDevicesFromTag(String tag, Set<String> addRegIds, Set<String> removeRegIds) throws APIConnectionException, APIRequestException {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        jpushClient.addRemoveDevicesFromTag(tag, addRegIds, removeRegIds);
        jpushClient.close();
    }

    /**
     * 获取发送消息的报告
     * @param msgId
     * @return
     * @throws APIConnectionException
     * @throws APIRequestException
     */
    public static MessagesResult selectReport(String msgId)throws APIConnectionException, APIRequestException {
        if(StringUtils.isBlank(msgId)){
            return null;
        }
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        MessagesResult reportMessages = jpushClient.getReportMessages(msgId);
        return reportMessages;
    }

    public static PushPayload buildPushObjectWithTag(JiGuangPushPoJo jiGuangPushPoJo, AndroidPushNotificationEnum androidPushNotificationEnum) {


        AndroidNotification androidNotification = AndroidNotification.newBuilder()
                .setUriActivity(androidPushNotificationEnum.getActivityUrl())
                .setAlert(androidPushNotificationEnum.getAlert())
                .setTitle(androidPushNotificationEnum.getTitle())
                .addExtras(androidPushNotificationEnum.getExtra())
                .build();
        Notification notification = Notification.newBuilder().addPlatformNotification(androidNotification).build();


        PushPayload.Builder builder = PushPayload.newBuilder().setPlatform(Platform.all()).setNotification(notification);

        Audience.Builder addAudienceTarget = Audience.newBuilder();

        if (CollectionUtils.isNotEmpty(jiGuangPushPoJo.getAndTags())&&CollectionUtils.isEmpty(jiGuangPushPoJo.getNotTags())){
            addAudienceTarget.addAudienceTarget(AudienceTarget.tag_and(jiGuangPushPoJo.getAndTags()));
        }
        if (CollectionUtils.isEmpty(jiGuangPushPoJo.getAndTags())&&CollectionUtils.isNotEmpty(jiGuangPushPoJo.getNotTags())){
            addAudienceTarget.addAudienceTarget(AudienceTarget.tag_not(jiGuangPushPoJo.getNotTags()));
        }
        if (CollectionUtils.isNotEmpty(jiGuangPushPoJo.getAndTags())&&CollectionUtils.isNotEmpty(jiGuangPushPoJo.getNotTags())){
            addAudienceTarget.addAudienceTarget(AudienceTarget.tag_not(jiGuangPushPoJo.getNotTags()))
                    .addAudienceTarget(AudienceTarget.tag_and(jiGuangPushPoJo.getAndTags()));
        }
        if (!jiGuangSwitch){
            addAudienceTarget.addAudienceTarget(AudienceTarget.registrationId(rids()));
        }
        return builder.setAudience(addAudienceTarget.build())
                .build();

    }

    public static PushPayload buildPushObjectWithRegIds(JiGuangPushPoJo jiGuangPushPoJo, AndroidPushNotificationEnum androidPushNotificationEnum) {
        AndroidNotification androidNotification = AndroidNotification.newBuilder()
                .setUriActivity(androidPushNotificationEnum.getActivityUrl())
                .setAlert(androidPushNotificationEnum.getAlert())
                .setTitle(androidPushNotificationEnum.getTitle())
                .addExtras(androidPushNotificationEnum.getExtra())
                .build();
        Notification notification = Notification.newBuilder()
                .addPlatformNotification(androidNotification).build();
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.registrationId(jiGuangPushPoJo.getRegistrationIds()))
                    .setNotification(notification).build();
    }

    public static PushPayload buildPushPocketWithRegId(String regId, AndroidPushNotificationEnum androidPushNotificationEnum) {
        AndroidNotification androidNotification = AndroidNotification.newBuilder()
                .setUriActivity(androidPushNotificationEnum.getActivityUrl())
                .setAlert(androidPushNotificationEnum.getAlert())
                .setTitle(androidPushNotificationEnum.getTitle())
                .addExtras(androidPushNotificationEnum.getExtra())
                .build();
        Notification notification = Notification.newBuilder()
                .addPlatformNotification(androidNotification).build();
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.registrationId(regId))
                .setNotification(notification).build();
    }

    public static PushPayload buildPushPocketWithRegIdForParam(String regId, AndroidPushNotificationPoJo androidPushNotificationPoJo) {
        AndroidNotification androidNotification = AndroidNotification.newBuilder()
                .setUriActivity(androidPushNotificationPoJo.getActivityUrl())
                .setAlert(androidPushNotificationPoJo.getAlert())
                .setTitle(androidPushNotificationPoJo.getTitle())
                .addExtras(androidPushNotificationPoJo.getMap())
                .build();
        Notification notification = Notification.newBuilder()
                .addPlatformNotification(androidNotification).build();
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.registrationId(regId))
                .setNotification(notification).build();
    }

    public static PushPayload buildRedpointMessageObjectWithRegIds(JiGuangPushPoJo jiGuangPushPoJo){
        Message message = Message.content(RED_POINT_CONTENT);
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.registrationId(jiGuangPushPoJo.getRegistrationId()))
                .setMessage(message).build();
    }

    public static PushPayload buildChangeRewardMessageObjectWithRegIds(JiGuangPushPoJo jiGuangPushPoJo){
        Message message = Message.content(INVITE_CHANGE_REWARD_CONTENT);
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.registrationId(jiGuangPushPoJo.getRegistrationId()))
                .setMessage(message).build();
    }

    public static PushResult sendPush(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        PushResult pushResult = jpushClient.sendPush(pushPayload);
        jpushClient.close();
        return pushResult;
    }

    public static void deleteTagBothPlatform(String  tag) throws APIConnectionException, APIRequestException {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        jpushClient.deleteTag(tag,null);
        jpushClient.close();
    }

    public static TagAliasResult getTagByRegId(String id) throws APIConnectionException, APIRequestException {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        return jpushClient.getDeviceTagAlias(id);
    }

    /** 增加和删除tag */
    public static void updateTagByRegId(String id,List<String> tag4remove,List<String> tag4add){
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        try {
            jpushClient.updateDeviceTagAlias(id, null, toSet(tag4add), toSet(tag4remove));
        }catch (Exception e){
            logger.warn("极光修改tag失败:"+id+" key:"+appKey,e);
        }
    }

    private static Set<String> toSet(List<String> list){
        Set<String> set =  Sets.newHashSet();
        if(CollectionUtils.isNotEmpty(list)){
            set.addAll(list);
        }
        return set;
    }

    public static Map<String,String> WALLETPAGEMAP(){
        Map<String,String> map = new HashMap<>();
        map.put("page","wallet");
        return map;
    }

    public static Map<String,String> MAINPAGEMAP(){
        Map<String,String> map = new HashMap<>();
        map.put("page","home");
        map.put("tabId","0");
        return map;
    }

    /**
     * 红包农场
     * @return
     */
    public static Map<String,String> REDPACKETFARMMAP(){
        Map<String,String> map = new HashMap<>();
        map.put("page","home");
        map.put("tabId","1");
        return map;
    }

    public static Map<String,String> INVITEMAP(){
        Map<String,String> map = new HashMap<>();
        map.put("page","inviteDetail");
        map.put("logFrom","6");
        map.put("url","https://api.tuipine.com/landPage/index/MTc=?from=6");
        return map;
    }


    public static Map<String,String> INVITEINMAP(){
        Map<String,String> map = new HashMap<>();
        //map.put("url","tiantianquwen://router/mine/invite?from=8&params={\"path\":\"/mine/invite\",\"data\":{\"url\"=\"https://api.tuipine.com/landPage/index/MTc=?from=6\"}}");
        //map.put("url","https://api.tuipine.com/landPage/index/MTc=?from=6");
        map.put("url",DataUtil.getDomian()+"apprentice/entry.html?from=7#/recruit?kefu=kefu");
        return map;
    }


    public static Map<String,String> LANDMAP(){
        Map<String,String> map = new HashMap<>();
        map.put("page","home");
        map.put("tabId","2");
        return map;
    }

    public static Map<String,String> LIMITPACKETMAP(){
        Map<String,String> map = new HashMap<>();
        map.put("page","timeRedPacket");
        return map;
    }

    public static Map<String,String> LUCKPACKETMAP(){
        Map<String,String> map = new HashMap<>();
        map.put("url","https://activity.tuibat.com/land/landPage?id=MTU5NQ&activityType=groupRedPacket");
        return map;
    }


    public static Map<String,String> POINTPACKETMAP(){
        Map<String,String> map = new HashMap<>();
        map.put("url","https://activity.tuibat.com/land/landPage?id=MTgwNw&activityType=clickTwiceEarn");
        return map;
    }


    public static Map<String,String> POINTPACKETINTRMAP(){
        Map<String,String> map = new HashMap<>();
        map.put("url","https://activity.tuibat.com/land/landPage?id=MTgwNw&activityType=clickTwiceEarn");
        map.put("page","groupRedPacket");
        return map;
    }

    public static Map<String, String> ACTIVITYCOINREWARD() {
        Map<String,String> map = new HashMap<>();
        map.put("url","https://api.tuipine.com/landPage/index/NA==");
        map.put("page","groupRedPacket");
        return map;
    }

    public static Map<String, String> ONECASHWITHDRAW() {
        Map<String,String> map = new HashMap<>();
        map.put("page","home");
        map.put("tabId","0");
        map.put("path", "/main/home");
        JSONObject data = new JSONObject();
        data.put("id",4);
        map.put("data", data.toJSONString());
        return map;
    }

    public static List<String> getCid(int count) throws APIConnectionException, APIRequestException {
        JPushClient jpushClient = new JPushClient(masterSecret, appKey, null, ClientConfig.getInstance());
        CIDResult cidResult = jpushClient.getCidList(count, null);
        return cidResult.cidlist;
    }

    private static List<String> rids(){
        List<String> list = new ArrayList<>();
        if (!jiGuangSwitch){
            list.add("18071adc03074a33fa5");
            list.add("1507bfd3f7eae7fb926");
            list.add("18071adc03074ad1eda");
            list.add("160a3797c80f8ecdf54");
            list.add("1507bfd3f7ea24e1a2c");
            list.add("18071adc03077642880");
            list.add("170976fa8aad91a0877");
            list.add("1507bfd3f79564a0231");
            list.add("18071adc035e3f252f7");
        }
        return list;
    }



}
