package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @author ElinZhou
 * @version $Id: AppType.java , v 0.1 2018/1/4 下午8:00 ElinZhou Exp $
 */
public enum RelationType {

    FRIEND(0, "好友"),

    ENEMY(1, "仇敌"),

    STRANGER(2,"陌生人"),

    ASSISTANT(3,"趣闻小秘书"),
    ;


    private Integer code;

    private String description;

    RelationType(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    private static final Map<Integer, RelationType> CACHE = Maps.uniqueIndex(Arrays.asList(RelationType.values()),
            RelationType::getCode);


    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }


    public static RelationType getByCode(Integer taskId) {
        RelationType relationType = CACHE.get(taskId);
        if (relationType != null) {
            return relationType;
        }
        return FRIEND;
    }

}
