/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.enums.RewardUnit;
import cn.com.duiba.tuia.news.center.enums.SignInReward;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

public enum OldUserSignInRewardV2 implements SignInReward
{
    DAY_ONE(1, 10L, RewardUnit.COIN),
    DAY_TWO(2, 15L, RewardUnit.COIN),
    DAY_THREE(3, 20L, RewardUnit.COIN),
    DAY_FOUR(4, 25L, RewardUnit.COIN),
    DAY_FIVE(5, 30L, RewardUnit.COIN),
    DAY_SIX(6, 35L, RewardUnit.COIN),
    DAY_SEVEN(7, -1L, RewardUnit.CHANGE);

    private Integer day;
    private Long rewardFee;
    private RewardUnit rewardUnit;
    private static final Map<Integer, OldUserSignInRewardV2> CACHE;

    private OldUserSignInRewardV2(Integer day, Long rewardFee, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFee = rewardFee;
        this.rewardUnit = rewardUnit;
    }

    @Override
    public Integer getDay() {
        return this.day;
    }

    @Override
    public Long getRewardFee() {
        if (this.rewardFee.equals(-1L)) {
            Integer reward3 = new Random().nextInt(30) + 20;
            return reward3.longValue();
        }
        return this.rewardFee;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return this.rewardUnit;
    }

    public static OldUserSignInRewardV2 getByDay(Integer day) {
        return Optional.ofNullable(CACHE.get(day)).orElseThrow(() -> new RuntimeException("\u7b7e\u5230\u5f02\u5e38"));
    }

    public static Long getTopReward(Integer day) {
        OldUserSignInRewardV2 oldUserSignInReward = OldUserSignInRewardV2.getByDay(day);
        return oldUserSignInReward.getTopRewardNew();
    }

    @Override
    public Long getTopRewardNew() {
        switch (this.getRewardFee().intValue()) {
            case -1: {
                return 20000L;
            }
        }
        return this.getRewardFee();
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(OldUserSignInRewardV2.values()), OldUserSignInRewardV2::getDay);
    }
}

