package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.flowadvert.FlowAdvertConfigDto;
import cn.com.duiba.tuia.news.center.dto.flowadvert.FlowAdvertDto;
import cn.com.duiba.tuia.news.center.dto.localnews.CityDto;

import java.util.List;

/**
 * @author zhou_wb
 * 用户广告配置
 */
@AdvancedFeignClient
public interface RemoteAdvertConfigService {
    /**
     * 后台查询信息流广告配置
     */
    List<FlowAdvertConfigDto>  selectAllForBk(Integer adGroup);


    /**
     * 根据版本获取配置列表
     */
    List<FlowAdvertConfigDto> selectByVersion(Long version);


    /**
     * 保存与更新配置列表
     */
    boolean save(FlowAdvertConfigDto flowAdvertConfigDto);


    /**
     * 更新配置状态
     */
    boolean updateStatus(Long id,Integer status);

    /**
     * 获取广告配置列表
     */
    List<FlowAdvertDto>  selectAllFlowConfig();
}
