package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.SkipDto;

import java.util.List;

/**
 * Created by xuefeng on 2019/2/15.
 */
@AdvancedFeignClient
public interface RemoteSkipService {

    /**
     * 查询
     * @return
     */
    List<SkipDto> queryList();

    /**
     * 新增
     * @param skipDto
     * @return
     */
    Boolean add(SkipDto skipDto);

    /**
     * 更新
     * @param skipDto
     * @return
     */
    Boolean update(SkipDto skipDto);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 根据版本&渠道 返回跳转url
     * @param version
     * @param source
     * @return
     */
    public String getUrl(String version, String source);
}
