package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.AppConfigDto;
import cn.com.duiba.tuia.news.center.enums.AppType;
import cn.com.duiba.tuia.news.center.enums.Platform;

import java.util.List;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: RemoteAppConfigService.java , v 0.1 2018/7/19 下午2:28 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteAppConfigService {

    /**
     * 查询所有生效的配置
     *
     * @return
     */
    List<AppConfigDto> listAllValidConfig(Platform platform);

    /**
     * 查询指定版本配置
     *
     * @param version 版本号
     * @return
     */
    List<AppConfigDto> listConfigByVersion(Long version, Platform platform);

    /**
     * 查询指定key的配置
     *
     * @param key
     * @return
     */
    List<AppConfigDto> listConfigByKey(String key, Platform platform);

    /**
     * 批量更新
     * @param list
     * @return
     */
    boolean batchUpdate(List<AppConfigDto> list);

    /**
     * 获取所有的可用
     * @return
     */
    List<AppConfigDto> listAll();

    /**
     * 新增或修改
     * @return
     */
    Boolean insertOrUpdateAppConfig(AppConfigDto dto) throws BizException;

}
