package cn.com.duiba.tuia.news.center.enums.message;

import cn.com.duiba.tuia.news.center.enums.AndroidPushCustomEnum;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Joiner;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 个人消息中心的消息类型
 * 此消息类型为个人消息中心的文案,由于文案几乎一致,减少数据库磁盘压力,数据库只存储code,查询时进行文案拼接
 * @author lichao 2018/11/27
 */
public enum MessageCode {

    REWARD_SUCESS("收益到账","收益到账通知","您昨日收入的{1}金币已经自动兑换为{2}元，今天也要继续努力赚钱呀。",true,AndroidPushCustomEnum.SHOUYI),//"2000^1"

    CASH_SUCESS("提现成功","提现成功","您的{1}元提现申请已审核通过，请及时在{2}中查看资金变动。",true,AndroidPushCustomEnum.CASH_SUCESS),//10^支付宝

    SALE_OWN_SETTLE("分销入账","您有一笔新订单收益>","商品已下单成功，返利{1}元，预计下月24日到账，点击查看>>",true,AndroidPushCustomEnum.SALE_OWN_SETTLE),//分销(自己)

    SALE_UP_SETTLE("分销入账","您有一笔新商品订单！","{1}元已入账：又有人通过队员分享的链接下单啦！",true,AndroidPushCustomEnum.SALE_UP_SETTLE),//分销(上级)

    CASH_REJECT("提现拒绝","提现失败","您的提现申请已被拒绝。点击查看详情>>",true,AndroidPushCustomEnum.CASH_SUCESS),

    CASH_TURNDOWN("提现驳回","提现驳回","你的提现申请因为一些原因失败了，请点击查看详情>>",true,AndroidPushCustomEnum.CASH_SUCESS),

    PATN_APPLY_ACCEPT("合伙人申请通过","申请通过","恭喜，您已成功晋升为合伙人，添加专属个人导师微信:{1} 赚更多！",true,
            AndroidPushCustomEnum.PARTNER_CENTER),

    PATN_APPLY_RECOVER("合伙人身份恢复","身份恢复","恭喜，您已恢复合伙人身份，邀请队员还能赚更多！",true,
            AndroidPushCustomEnum.PARTNER_CENTER),

    MAMMON_PUSH("新城送财神活动","又有人扫码成为你的财神，来看看吧","{1}扫码成功，你们各得{2}元，喊ta打开趣闻，红包直接到账",true,
            AndroidPushCustomEnum.COMMON_H5),

    MAMMON_NO_PUSH("新城送财神活动","又有人扫码成为你的财神，来看看吧","{1}扫码成功，你们各得{2}元，喊ta打开趣闻，红包直接到账",false,
            AndroidPushCustomEnum.COMMON_H5),

    //todo 临时
    ARTICLE_TEST("文章推送消息测试","文章推送消息测试","文章推送消息测试",true,
            AndroidPushCustomEnum.COMMON_H5),

    CLEAR_ACCOUNT("余额即将被清空通知","余额即将被清空通知","您好，系统发现您已经28天没有打开过天天趣闻了。如果3天内您依然没有使用天天趣闻，根据趣闻用户协议，将于{1}清空您的账户余额。",false,null),

    COIN_BOX_READING_REWARD("宝箱分享金币到账","金币入账提示>","有好友打开了你分享出去的页面，奖励已入账>>",true,AndroidPushCustomEnum.INVITE),


    NEW_USER_MESSAGE("恭喜您获得了1元提现券","恭喜您获得了1元提现券","快打开天天趣闻领取奖励吧！",true,AndroidPushCustomEnum.SHOUYI),

    BOX_READING("宝箱分享金币到账","金币入账提示>","有好友打开了你分享出去的页面，奖励已入账>>",true,AndroidPushCustomEnum.INVITE),

    PDD_HELP_NEW_JOINER("助力免单好友助力成功","好友助力成功提示","恭喜,又有1名好友帮你助力了！再邀请{1}名好友即可免费拿心仪商品",true,AndroidPushCustomEnum.COMMON_H5),

    PDD_HELP_SUCCESS("助力免单商品免单成功","【恭喜】商品免单成功通知！","您参与的助力享免单活动已成功，快去填写地址吧>>",true,AndroidPushCustomEnum.COMMON_H5),

    PRAISE_STUDENT("赞赏徒弟","你的师父赞赏了你","由于你今天的出色表现，你的师父给你点了一个大大的赞！再接再励努力赚钱吧。",true,AndroidPushCustomEnum.COMMON_H5),

    INVITE_SUCCESS("填写邀请码成功","恭喜你收到了一位徒弟！","{1}刚刚绑定了你的邀请码，5元奖励金将分3天发放。记得提醒他读文章，每天读完5篇你才能获得当日的奖励。",true,AndroidPushCustomEnum.COMMON_H5),
    INVITE_RECEIVE_SUCCESS("自动领取邀请奖励成功","恭喜你获得收徒奖励","你的徒弟{1}今天已读够5篇文章，帮你赢取了收徒奖励{2}元，点击这里去看看>",true,AndroidPushCustomEnum.COMMON_H5),


    JUMP_CASH_SUCESS("提现成功","提现成功","恭喜！您的{1}元提现申请已提前审核通过，请及时查看资金变动。",true,AndroidPushCustomEnum.JUMP_CASH_SUCESS),//10

    NEW_USER_PLANT_MESSAGE1("新用户注册当日仅没有种下摇钱树","你有0.66（种树的金额）元现金待领取！","种下摇钱树，马上拿现金，还能收取丰厚金币",true,AndroidPushCustomEnum.SHOUYI),

    NEW_USER_PLANT_MESSAGE2("新用户注册当日仅没有阅读文章","你有1.00（阅读的金额）元现金待领取！","阅读资讯，马上拿现金，明天就提现",true,AndroidPushCustomEnum.SHOUYI),

    NEW_USER_PLANT_MESSAGE3("新用户注册当日没有种下摇钱树也没有阅读文章","你有1.22（种树+阅读的金额）元现金待领取！","快来领取新人现金红包，明天就能提现啦",true,AndroidPushCustomEnum.SHOUYI),

    NEW_USER_PLANT_MESSAGE4("新用户注册超过48小时，超过两日没有种树","快来赚钱啦！","种下今天的摇钱树，立即开始赚金币",true,AndroidPushCustomEnum.SHOUYI),

    NEW_USER_PLANT_MESSAGE5("新用户注册超过48小时，昨日种过树且今天还没种树","今天你还有300金币待领取！","种下今天的摇钱树，立即开始赚金币",true,AndroidPushCustomEnum.SHOUYI),

    NEW_USER_PLANT_MESSAGE6("今日种下摇钱树，且有待收金币时","收！金！币！啦！","你的摇钱树的金币已经满啦，快来收取吧！",true,AndroidPushCustomEnum.SHOUYI),
    ;

    private String name;//通知场景

    private String title;//通知标题

    private String message;//通知文案

    private boolean needPush;//是否需要推送

    private AndroidPushCustomEnum pushType;//推送跳转页面类型

    MessageCode(String name, String title, String message, boolean needPush, AndroidPushCustomEnum pushType) {
        this.name = name;
        this.title = title;
        this.message = message;
        this.needPush = needPush;
        this.pushType = pushType;
    }

    /** 获取内容的存入数据库的message */
    public static String getDbMessage(String... value){
        if(value==null){
            return null;
        }
        return Joiner.on("^").join(value);
    }

    private static Map<String, MessageCode>  cache = Stream.of(MessageCode.values()).collect(Collectors.toMap(a -> a.name().toUpperCase(), a -> a));


    public static MessageCode getByCode(String code){
        return cache.get(code.toUpperCase());
    }



    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isNeedPush() {
        return needPush;
    }

    public void setNeedPush(boolean needPush) {
        this.needPush = needPush;
    }


    public AndroidPushCustomEnum getPushType() {
        return pushType;
    }

    public void setPushType(AndroidPushCustomEnum pushType) {
        this.pushType = pushType;
    }
}
