package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.req.RiskCheckReq;
import cn.com.duiba.tuia.news.center.dto.risk.HitRiskDto;
import cn.com.duiba.tuia.news.center.dto.risk.NewsRiskInfoDto;
import cn.com.duiba.tuia.news.center.dto.risk.RuleHitUserDto;
import cn.com.duiba.tuia.news.center.enums.OpenInstallSourceType;

import java.util.Date;
import java.util.List;

/**
 * Created by xuefeng on 2018/11/21.
 */
@AdvancedFeignClient
public interface RemoteRiskService {

    /**
     * 端外阅读奖励风控检验
     *
     * @param req
     * @return true:风控通过 false:风控禁止
     */
    Boolean readCheck(RiskCheckReq req);

    /**
     * 记录金币奖励行为
     *
     * @param req
     */
    void recordShare(RiskCheckReq req);

    /**
     * 分享链接添加加密分享时间
     *
     * @param url 分享链接
     * @return
     */
    String buildShareUrlWithTime(String url);

    /**
     *  宝箱分享链接添加加密分享时间
     *
     * @param url 分享链接
     * @return
     */
    String buildCoinBoxShareUrlWithTime(String url);

    /**
     * 根据userid/phone查询用户风控分析信息
     * @return
     */
    NewsRiskInfoDto getRiskInfoByUserId(Long userId, String phone);

    /**
     * 获取用户风控命中规则
     * @param userId
     * @return
     */
    List<HitRiskDto> getHitRiskDtos(Long userId);

    /**
     * 解除用户风控
     * @param ruleId
     * @param operateUserId 操作人id
     * @param operateName   操作人姓名
     * @return
     */
    Boolean removeRuleHit(String ruleId, Long userId, Long operateUserId, String operateName);



    /**
     * 批量解除用户风控
     * @param ruleId
     * @param operateUserId 操作人id
     * @param operateName   操作人姓名
     * @return
     */
    Boolean removeRuleHitList(List<String> ruleId, Long userId, Long operateUserId, String operateName);

    /**
     * 获取风控规则
     * @return
     */
    List<String> getRules();

    /**
     * 根据规则&时间查询命中用户
     * @param rule
     * @param startTime
     * @param endTime
     * @return
     */
    List<RuleHitUserDto> getByRuleName(String rule, Date startTime, Date endTime);
}
