package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.req.DeviceLoginReq;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteDeviceLoginService.java , v 0.1 2018/2/2 上午11:58 ZhouFeng Exp $
 */
@AdvancedFeignClient
public interface RemoteDeviceLoginService {

    /**
     * 设备登录(1.2.0版本发布后删除)
     *
     * @param deviceId
     * @param appSource
     */
    @Deprecated
    void login(String deviceId, String appSource);

    /**
     * 新设备登录
     *
     * @param deviceId
     * @param appSource
     * @param version
     */
    void newLogin(String deviceId, String appSource, String version);


    /**
     * 设备登陆添加orderId
     * @param deviceLoginReq
     */
    void newLoginV2(DeviceLoginReq deviceLoginReq);


    /**
     * 根据用户deviceId获取当时的tuia的orderId
     * @param deviceId
     * @return
     */
    String getOrderIdBy(String deviceId);

}
