/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.enums.ChangeTradeCode;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ChangeIncomeCode implements ChangeTradeCode
{
    SETTLE(1, "\u91d1\u5e01\u5151\u6362\u73b0\u91d1"),
    NEW_USER_REWARD(2, "\u65b0\u7528\u6237\u5956\u52b1"),
    SIGN_IN(3, "\u7b7e\u5230\u5956\u52b1"),
    WITHDRAW_TURN_DOWN(4, "\u63d0\u73b0\u9000\u8fd8\u5165\u8d26"),
    INVITE_INCOME(5, "\u9080\u8bf7\u597d\u53cb"),
    LIMIT_PECKET(6, "\u9650\u65f6\u7ea2\u5305"),
    NEW_TICKET_WITHDRAW(7, "\u9996\u6b21\u63d0\u73b0\u6210\u529f"),
    LUCK_PACKET_SEND(8, "\u7ea2\u5305\u6536\u76ca"),
    LUCK_PACKET_RECEIVE(9, "\u9886\u53d6\u7ea2\u5305"),
    POINT_PACKET(10, "\u75af\u72c2\u62bd\u5956"),
    NEW_USER_READING(11, "\u9605\u8bfb\u6587\u7ae0\u5956\u52b1"),
    NEW_USER_DRAWED(12, "\u6536\u53d6\u7ea2\u5305\u5956\u52b1"),
    NEW_PLAN_DRAWED(13, "\u6536\u53d6\u7ea2\u5305\u5956\u52b1"),
    SALE_TRIBUTE_SETTLE(14, "\u56e2\u961f\u8fdb\u8d21\u7ed3\u7b97"),
    SALE_OWN_SETTLE(15, "\u76f4\u5c5e\u4f63\u91d1\u7ed3\u7b97"),
    LOGIN_REWARD_LOGIN(16, "\u65b0\u4eba\u767b\u5f55\u5956\u52b1"),
    LOGIN_REWARD_READ(17, "\u65b0\u4eba\u9605\u8bfb\u5956\u52b1"),
    XIANWAN_REWARD(18, "\u5b8c\u6210\u6e38\u620f\u4efb\u52a1"),
    LOGIN_REWARD_FARM(19, "\u65b0\u4eba\u79cd\u690d\u5956\u52b1"),
    TRY_PLAY_REWARD(20, "\u8bd5\u73a9\u5956\u52b1"),
    GOLD_TREE_REWARD(21, "\u6447\u94b1\u6811\u79cd\u690d\u5956\u52b1"),
    NEW_LOGIN_184_REWARD(22, "\u65b0\u4eba\u6bcf\u65e5\u767b\u5f55\u5956\u52b1"),
    MAMMON(23, "\u8d22\u795e\u7ea2\u5305"),
    MIDONG_REWARD(24, "\u5e94\u7528\u8bd5\u73a9\u4efb\u52a1\u5956\u52b1"),
    NEW_LOGIN_REWARD_190(25, "\u65b0\u4eba\u767b\u5f55\u5956\u52b1"),
    SURVERY_REWARD(26, "\u5b8c\u6210\u95ee\u5377\u8c03\u7814"),
    YOUMI_REWARD(27, "\u5e94\u7528\u8bd5\u73a9\u4efb\u52a1\u5956\u52b1"),
    FORM_REWARD(28, "\u586b\u5199\u8868\u5355\u5956\u52b1"),
    FICTION_ADVERT(29, "\u5c0f\u8bf4\u5956\u52b1"),
    ARTICLE_REWARD(30, "\u9605\u8bfb\u7ffb\u500d\u5956\u52b1"),
    SIMPLE_PLAY(31, "\u7b80\u5355\u8d5a");

    private Integer code;
    private String desc;
    private static final Map<Integer, ChangeIncomeCode> CACHE;
    public static final Set<Integer> CODE_IN_TASK;

    private ChangeIncomeCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public static ChangeIncomeCode get(Integer code) {
        return CACHE.get(code);
    }

    public static boolean codeInTask(Integer code) {
        return CODE_IN_TASK.contains(code);
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(ChangeIncomeCode.values()), ChangeIncomeCode::getCode);
        CODE_IN_TASK = Stream.of(ChangeIncomeCode.SIGN_IN.code, ChangeIncomeCode.INVITE_INCOME.code, ChangeIncomeCode.LIMIT_PECKET.code, ChangeIncomeCode.LUCK_PACKET_SEND.code, ChangeIncomeCode.POINT_PACKET.code, ChangeIncomeCode.NEW_USER_READING.code, ChangeIncomeCode.NEW_USER_DRAWED.code, ChangeIncomeCode.NEW_PLAN_DRAWED.code).collect(Collectors.toSet());
    }
}

