package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.checkWhite.CheckWhiteDetailDto;
import cn.com.duiba.tuia.news.center.dto.checkWhite.CheckWhiteDto;
import cn.com.duiba.tuia.news.center.dto.checkWhite.CheckWhiteReq;
import cn.com.duiba.tuia.news.center.dto.checkWhite.CheckWhiteUrlDto;

import java.util.List;


@AdvancedFeignClient
public interface RemoteAppCheckWhiteService {

    /**
     * 获取是否在过审白名单中
     * @param checkWhiteReq
     * @return
     */
   boolean inWhiteList(CheckWhiteReq checkWhiteReq);

    /**
     * 增加白名单
     * @param checkWhiteReq
     * @return
     */
   boolean add(CheckWhiteReq checkWhiteReq) throws BizException;

    /**
     * 删除白名单
     * @param id
     * @return
     */
    boolean delete(long id);


    /**
     * 这边暂时不分页
     * @return
     */
    List<CheckWhiteDto> getList();


    /**
     * 返回是否在过审核白名单中和拦截的url
     * @param checkWhiteReq
     * @return
     */
    CheckWhiteDetailDto inWhiteListDetail(CheckWhiteReq checkWhiteReq);



    /**
     * 增加url
     * @param url
     * @return
     */
    boolean addUrl(String url) throws BizException;


    /**
     * 删除url
     * @param id
     * @return
     */
    boolean deleteUrl(long id);



    /**
     * 这边暂时不分页
     * @return
     */
    List<CheckWhiteUrlDto> getUrlList();


}
