package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.StreamDirect.StreamDirectAddReq;
import cn.com.duiba.tuia.news.center.dto.StreamDirect.StreamDirectGroupConfigDto;
import cn.com.duiba.tuia.news.center.dto.StreamDirect.StreamDirectReq;
import cn.com.duiba.tuia.news.center.dto.StreamDirect.StreamDirectSlotConfigDto;
import java.util.List;

/**
 * description: 信息流直投广告投放配置remoteService
 *
 * author: xiaotian
 */
@AdvancedFeignClient
public interface RemoteStreamDirectSlotService {


    /**
     * 获取各个位置的位移广告组
     * @return
     */
    List<StreamDirectGroupConfigDto> queryGroupList();

    /**
     * 根据组Id获取具体广告详情
     * @param groupId
     * @return
     */
    List<StreamDirectSlotConfigDto> querySlotList(Long groupId);

    /**
     * 添加广告计划
     * @return
     */
    boolean add(StreamDirectAddReq streamDirectAddReq) throws BizException;

    /**
     * 更改广告组的状态
     * @param groupId
     * @param status
     * @return
     */
    boolean updateStatus(Long groupId,Integer status);

    /**
     * 根据参数获取本次列表该出的广告
     * @return
     */
    List<StreamDirectSlotConfigDto> querySlotForDirect(StreamDirectReq streamDirectReq);

}
