package cn.com.duiba.tuia.news.center.dto;

import java.io.Serializable;

/**
 * @author ElinZhou zhoufeng@duiba.com.cn
 * @version $Id: UserInfoUpdateDto.java , v 0.1 2019-02-13 14:55 ElinZhou Exp $
 */
public class UserInfoUpdateDto implements Serializable {
    private static final long serialVersionUID = 783936411216091283L;

    public static final String CHINA = "CN";

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 城市编码，如果此值不为null，将忽略city、province、country几个参数
     */
    private Integer adCode;

    /**
     * 用户当前城市
     */
    private String city;

    /**
     * 用户当前省
     */
    private String province;

    /**
     * 用户当前国家
     */
    private String country = CHINA;

    /**
     * 性别 1时是男性，值为2时是女性，值为0时是未知
     */
    private Integer gender;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Integer getGender() {
        return gender;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Integer getAdCode() {
        return adCode;
    }

    public void setAdCode(Integer adCode) {
        this.adCode = adCode;
    }
}
