package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.lottery.LastLotteryDetail;
import cn.com.duiba.tuia.news.center.dto.lottery.OwnRewardListDto;
import cn.com.duiba.tuia.news.center.dto.lottery.RewardNotificationDto;
import cn.com.duiba.tuia.news.center.dto.lottery.TicketDetail;

import java.util.List;


@AdvancedFeignClient
public interface RemoteLotteryService {


    /**
     * 获取上期开奖结果
     */
    LastLotteryDetail getDetial(Long userId);



    /**
     * 获取我的中奖记录（取最近7天的记录，分页获取）
     */
    List<OwnRewardListDto> getOwnRewardList(Long userId,Integer pageNo,Integer pageSize);



    /**
     * 获取ticket （视频 or buy）
     */
    TicketDetail  getTicket(Long userId,Integer type) throws BizException;



    /**
     * 获取获奖情况（开奖完，是否期间有中过奖项）会更新时间
     */
    RewardNotificationDto getNotification(Long userId);


    /**
     * 获取获奖情况（开奖完，是否期间有中过奖项）不会更新时间
     * @param userId
     * @return
     */
    RewardNotificationDto getNotificationForBannerList(Long userId);

    /**
     * 发奖任务（和获奖有延迟，因为依次发）
     */
    Long rewardSettle();

}
